package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.models.FieldSelectModel;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.admin.content.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidatorMessageListRenderer;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminFormTypeUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<WikittyExtension> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1ZTW/cuBmWnfjbjr/iOImziT1JF06RlbO7wLZAtu3a3pnY7uQDnjEa1AeXI3FmmHBEhaJseY0W/Qn9Ce29lwK99VT00HMPvSz6F4rFoiiweyn6khqNRI1mRp4kQOgR+fLl8zzk+5Ki/vhvY8zjxsZrFAQm9x1BWtg82H716kXtNbbEl9izOHEF40b4b2TUGD02ZuxOvSeM+8dl2X2r3X1rl7Vc5mAn0ftJ2Zj2xDnFXhNjIYwP9B6W521VOs1PAtfnkdcOqCyvv//2m9Hf2b/9w6hhBC6gmwUq64N6xUyulo1RYgtjCUY6RVsUOQ2AwYnTALxzsm6XIs97jlr4rfEbY6JsjLuIgzNhFPJTVj5U/8AVxsKDbbtFnF3mCDA/2n8sjB9ZrGW+9jnxWohbTeyZpxzZxPSJiaStaYXGpupZYrxVPXfx0b7rKrfjwrhaw8gRxg8Yb5heU0JsMPOMvCFCnJu/CP8WA/DhEebE3SYEY7SGuDBuaqJ5ZyCBWUU1imPjMUEExSCW1CVo2xyUUQ1TaTEvjCllUcZ1EfWZtjhGAkvIwljWOu74QjBH9UzQYPZ5eoSXyME0hjFTJ5jaZeKBdrJqURa3Os2TD0JIj+XzdVnc6bSNh2jk0029Ze7BQcXijFI5GMzIqoYgbtJ7TbTnRT6uyaLQaZqFORfPmE0Ara38dcm7t8OCNnZurGkGEA5mHA7xeh05Nsa4D9UwYcfdEXQITWHs3EzFjnSoWv93Y/mff/nXn0tRwPwQxl7JNE3EOyxklzMXc0Hk0PNhtPiC0K1nyH1ybEx5mEKyUMngTgawSrsZwMF4i7K7Kbube8hrgouxia//+rcbv/rHFWO0ZExThuwSkvb7sKSaHFRg1A7cn32hEM2eTUK5AP+vwJKrg7WQCxUWaB1RD/6OMxe99RMVczXGbcxfIgLTZUf1Aeh0J0OnDtja1N//u1z50xeRViOA/VZP81ivsV8a48ShxMEqvbQzR2Y6mXE97NsszhBZOcOArDF5UIVQ3UG8HQhbqvw0S5IFuSqJ4zPfK6NzBmFmXBVc6rEEGarKfKtZDFzk2KFq7bYZm5wSEKlCvoKnkc8CXw7wRNGWv34iUUwfVFxKhIyEwTiWm4yTrwALotuUNJyWypv3L5KhVZElpEJPQPryzN3i82rx8NcAqs5Ukr1w8Nl6CX5vFiqYk3rhkXoyd16Uv3y0/slnD8H2RjxOFQfiJfOIgCwH6/QiTAWR20xK46GNG+W34Vht9GNVLpaq74vTXMRJOR3AKJWPL82q0I/V4f7TvfdG61pEK/Q6gNe04nVIGs3+xEbjTWs53FHVk3mGKey4ULti4zryqdilzMMvIMGhEM6yzU4cJppA+IQ5J5Zs7sYEArcgpZQ4xLM7IB5GAMpJU6FfuCjAxi57miCzX8hgC6rKpkFOr8joBR1hqYf0ZCezTiThyZaDW8whFgRzKR58RR9cGWcjmJTtJUIHUhvroLgdooDUDSrKQ0udNPxI0ySgXZjD0GpfJivYmJUtZCF5IKkSt6r83e3tD2bSjVndz2Cl22dzXIk47iZt8xO+kZLdpMxCafXTZKcER45H4SCS5tvTXcTzThbP0Cib4EJEsAxHWx818kzmBHbkzgD75McXG8iysCvKaojNBhahUJsPTfjdrn34aL1Q5yelw4IMcV2Z9tSFEM06T0kxQT7+sfORrNaFuJ3dW5/0e73FANtsPZbSepQOBykyPpwi2Dl5ujNQEf+NvlaOMgWSVjkE8t/kF8h/k1Ogo5/nEKhNcVVDVfcphXchjCWPU+IRddxYutgg3pFjY4tBtGF7U0qUlOBlSoLppB9dhbUe4+kyrGfJEBsP0KHUMcyvwy0NlwMvPyhDicWL/kI8TwmxQDE6xR/1luODnsPqgnyYuS5SzrNluR7J8jzhPX++XNQQ4gBeSzXKr1KUr4YmOs2VLic6vdtZ9KRZNqXZiFIRTIbccdXrbZLIsz47Lhj323GhOT+KpQSKUBBPB7IdA1lNAQnts6HMSIvt0GF+NAtJNPKqoieW/MeQKYVEOsuPYzGBw6JEnWVTO/Iwosx3oOwqp8MJ0+DMd3U8T4fDc62D56n0mR/OcmrtytuknifGyyCa6yC63DK+ngAUtGhFcIxaXalhGERLHUSvIr/DwRJN7CGf+6n4qr4rrGrkd7jVhGE8qkMqDh1mReksP47VNI73GWyLHUA755cNt5UuYN0ZesgVPp+Adbk1nlSLtFzGRTGQpQ5rf5jJU6f8/YTP/Kju9kAFG2Y3uOJwmk0rzd4XsPChp2qXBhbqlh/YvV7AOCZwmgt0ZIfvsP8ehg6HO5OEYyah4N5LS9b2OZPsyfv3IQ95mTj0Q15o0u+QJy36H/KURW8asxGNd6HiEZHaJr00ldCkHxVpkYOKNBtApQIm+aksaShQTd0Lp05nGpextk3mFUXSjc5mLYuNsutzZJB0tqVNjnesqTqzfE+/8deAT6rruiqqpbHrr2VvfSL2OutqXn7hYaeYF6NX/f4fD2LCd2PC8utVSDiC0COoouZBdEeFMU7bd/hr6oJ1hwXhpf5m+9Pdo/XH8sUxQrMco2kbZEOIvvzluLeMbz+ufW4jgdZrkJaI0/hpl98RWU7ncBmtyc/DzyTrSAhOar7APXyuDvQJ1SPfyeL7bA/33tnDRg5e7cmSXv6T7eXDHF6yLuP7ANsEl/8H4Lsh6sYfAAA=";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.sharengo.wikitty.WikittyExtension bean;
    protected javax.swing.JPanel content;
    protected javax.swing.JButton create;
    protected javax.swing.JButton createForm;
    protected jaxx.runtime.swing.Table fieldListUI;
    protected jaxx.runtime.swing.HBox lastModified;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminFormTypeUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
        content.removeAll();
        lastModified.removeAll();
        if (getBean() != null){
            for (int i = 0 ; i < getBean().getFieldNames().size() ; i++){
                String fieldName = getBean().getFieldNames().get(i);
                FieldType fieldType = getBean().getFieldType(fieldName);
                String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
                FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                        VradiHelper.getFieldTypeEnum(fieldType), i);
                create(fieldSelectModel);
            }
            String date = getBean().getTagValue(VradiHelper.TYPE_LAST_MODIFIED_DATE);
            String time = getBean().getTagValue(VradiHelper.TYPE_LAST_MODIFIED_TIME);
            String user = getBean().getTagValue(VradiHelper.TYPE_LAST_MODIFIED_BY);
    
            log.debug(date + " " + time + " " + user);
            if(date != null && time != null && user != null) {
                String labelText = String.format(_("vradi.entity.lastModified.strings"), date, time, user);
                lastModified.add(new JLabel(labelText));
            }
        }
        title.setText(_("vradi.adminForm.title", getStringValue(bean == null ? "" : bean.getName())));
        setModified(false);
    }
    
    @Override
    public void save(){
        java.util.List<FieldSelectModel> fields = new ArrayList<FieldSelectModel>();
        for(Component component : content.getComponents()) {
            fields.add(((FieldSelectUI)component).getBean());
        }
        getHandler().saveFormType(this, getHelper(), fields, getBean());
        setModified(false);
    }
    
    protected void create() {
        create(new FieldSelectModel(content.getComponentCount()));
    }
    
    protected void create(FieldSelectModel fieldSelectModel){
       FieldSelectUI result = new FieldSelectUI(this);
    
       result.updateBean(fieldSelectModel);
       result.addPropertyChangeListener(FieldSelectUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    FieldSelectUI field = (FieldSelectUI) evt.getSource();
                    log.debug("field " + field + " modified value =  " + evt.getNewValue());
                    setModified(true);
                    if(evt.getNewValue() == null) {
    
                        if(field != null) {
                            field.setVisible(false);
                            content.remove(field);
                        }
                        if(field.getBean().isUpOrDown() != null) {
                            if(field.getBean().isUpOrDown() && field.getBean().getPosition() == 0) {
                                content.add(field, 0);
                            } else if(!field.getBean().isUpOrDown() && field.getBean().getPosition() == content.getComponentCount()) {
                                content.add(field);        
                            } else {
                                int fieldToMovePosition = field.getBean().isUpOrDown() ?
                                        field.getBean().getPosition() - 1 : field.getBean().getPosition();
                                int fieldToAddPosition = field.getBean().isUpOrDown() ?
                                        field.getBean().getPosition() - 1 : field.getBean().getPosition() + 1;
                                FieldSelectUI fieldToMove = (FieldSelectUI) content.getComponent(fieldToMovePosition);
                                log.debug(fieldToMove.getBean().getNameValue() + " : " + fieldToMove.getBean().getPosition());
    
                                content.add(field, fieldToAddPosition);
                                for(int i = 0 ; i < content.getComponentCount() ; i++) {
                                    FieldSelectUI fieldSelectUI = (FieldSelectUI) content.getComponent(i);
                                    fieldSelectUI.getBean().setPosition(i);
                                    log.debug(fieldSelectUI.getBean().getNameValue() + " : " + fieldSelectUI.getBean().getPosition());
                                }
                            }
                            field.getBean().setUpOrDown(null);
                            field.setVisible(true);
                        }
                        content.validate();
                    }
                }
        });
        result.setModified(false);
    
       content.add(result);
       validate();
    }
    
    protected void updateBeanFromEntity(WikittyExtension bean) {
        setBean(bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminFormTypeUI() {
        super();
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        create();
    }

    public void doActionPerformed__on__createForm(java.awt.event.ActionEvent event) {
        getHandler().createFormType(this, getHelper()); setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.sharengo.wikitty.WikittyExtension getBean() {
        return bean;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getCreateForm() {
        return createForm;
    }

    public jaxx.runtime.swing.Table getFieldListUI() {
        return fieldListUI;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(org.sharengo.wikitty.WikittyExtension newValue) {
        org.sharengo.wikitty.WikittyExtension oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(fieldListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToFieldListUI() {
        if (!allComponentsCreated) {
            return;
        }
        fieldListUI.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add(create, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add(createForm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
        content.setLayout(new GridLayout(0,1));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new javax.swing.JButton());
        create.setName("create");
        create.setText(_("vradi.adminField.new"));
        create.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createCreateForm() {
        $objectMap.put("createForm", createForm = new javax.swing.JButton());
        createForm.setName("createForm");
        createForm.setText(_("vradi.adminForm.createForm"));
        createForm.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForm"));
    }

    protected void createFieldListUI() {
        $objectMap.put("fieldListUI", fieldListUI = new jaxx.runtime.swing.Table());
        fieldListUI.setName("fieldListUI");
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        title.setName("title");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToToolbar();
        addChildrenToBody();
        addChildrenToFieldListUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(content);
        
        // apply 1 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setFont(new Font("Serif", Font.BOLD, 26));
        title.setHorizontalTextPosition(JLabel.LEFT);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createTitle();
        createCreateForm();
        createFieldListUI();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.title"));
        createCreate();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createContent();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
    }

}