package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.admin.content.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminPopupUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_TABS_MODEL = "adminTabs.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1ZTW8bNxqmnUi2HDv+ipM2SVPFCRbOwhnnoyiKTdDWdqXEruoYlgwE64OX0lASk9FwwuHYco1d7E/oT+je97LA3noqeui5h16K/oWi6AIL7GnRlxyNNBzNSGM5ASJLfF8+fJ5nyJcU9c9fUMbl6PYr3G4b3LMFbRFje/3lyxfVV6QmPiNujVNHMI78f2PjaPwAXTK77a5Adw5Ksvtap/vaJms5zCZ2qPeTEppyxYlF3CYhQqD39B41110rd8NP2o7HA9QuqTjUr3/7dfwr8+//GEeo7QC7GZCSH9arp+RiCY1TU6AFGOkIr1nYbgANTu0G8J2RbZsWdt0d3CJv0N/QRAllHcwBTKDl9JIVhurfdgSaxmaL2rvM8Zz9LYFWa6xlvPI4dVuY15rENY44NqnhUUMlGuuhdMdROFmBcipYwVWw/5ok2jbcY+BtbENblZi72FaUc90e03cV0g4+2t96INAfU42rsiXAdCzOQ9k2nxx/NCT+OCZ+2VcGjLDHPZD3IBXTboco39zd7Q1PCGaD6EXNKb9Zdyl3F/zbsusMsq9rE8nv1Ik6/R2UF/mYwKOkwOOkwAdBgKMbGgdYJkZvmfTm8dgBynAPmgV656B/Ze1ByF9T70TWlARU0f9fXfzxm5//XQwW0n0Yeyk2NVQHYII7nDmECyqHnvVXkSeotfYFdp4coJxLLCgiqkjcjCFW7oSBHIw3L7sbsrvxHLtNgMhM/PTtd1f/8sMFNF5EUxbDZhHL/C2UE00OLjDLbDuffKoYTR9Pwusc/L8AXtYhW+CqBTZl6thy4W+WOfiNF2qYqTJuEr6LqS2IGbS3waebMT51yVZz3/93sfyvTwOvxoD7u4npPb8yf0ZZalvUJqrsdCpKbJm55LjEM1mvcsTVEgTVZHK7wpi1gXlnGhnq9VGcJXM1Buxsj3luCZ8wmPzoouDSjwWoXBXm1ZqFtoNt03etE7tk0iMKJpXpl/Bp7MO2Jwf4k5It3z2VLKa2y45FhSw6w3ksNhmnXwIXbK1btGG3VD29cxpem2X5uslsV2BbuMZmYadS2PsrkKozVXxPbXKcL8L7leUy4bS+vKo+GRsvSp+t5h99eA9yr/bGqZC22GUuFRQ+otnT7RKuEiuAjZWU9XPgXUZQAUtrJFW3B6kqFYqVt6VpJtCkQIcoyilFJVIXo6laHqRqb+vZ87cm63Igy0cdomtK6dqjjeZgYePBQwWB/l6iPhnHxIK9BlqXTFLHniU2LeaSF1DgsE9n0WSHNhNNEHzI7MOaDPdzAoNbUFKKHNazM2Q9jAGVw6ZiP3e6DFua7GmAzd5yjFpwVYaGgV6Qqxd8hKnuy5OdjDqVgidbNmkxm9ZgMRd7gy/pg6vkeAaTMl6E8DAWmS6L6z4LKN3gogFlqE4bXuBpmNAmPEM/a0sWK5T1c6EKCahyFepUFN6tZDx4kk5P1Z0YVXp+vMalQONmODe94KsR2w2L1XDU/ajYnODYdi0sSFRvIlyg82acTj8pXuBcILAER14PN9I8zAliy50B9smHp7dxrUYcUVJDrDSI8I1auWfA+07rvdX8cp0fFveW5RLXnek8Op+iUecRKybow4/s+7JZN+J6fG/9ob+fbAbkxvuxEPWjuDfMkexojhD78NnGUEe81/pc2Y81SGalMMh7nd4g73VKg/Y/T2FQR+I1jVXdsyz4jkSI1HFEXaqOGwunt6m7b5ukxmC1EXNFWhS2YDdiwVQYR3fhRsJ4ug35OBt6yUN8KHYT0/vwrsbLZryFY5yYPx1sxE7EiDmL4CNyP9mO9xKH1Q35Q+y8iIDH23IlsGUnhJ6+Xs5rDEmbCl3yy4jki36KLnOpD0SXdz1OnkyLlzQdSCpAyog7LpihC/liwI4LyYN2XAinZ7EQYuEb4upE1ntErkWI+PnxVC7JjHUfMD2buTAb+WU9kUv6Y0hOMZFg6XnMh3jULKrOspEdeRRTZrtUNhXoaMY0OPMcnc+z0fhc7vJ5JjHT01mMzN3KiZN8YjwLo5kuo7NN4yshQu2WVRac4FZfaRiF0UKX0csAdzRaondRFaZVOS+t7n3WaLOJwHiWTqkw8jIrSLD0PK5FebzNxTbfJbRxctblttRHrL9CjzjDZ0O0zjbHw27RlsO4KLTlq05ra5SHp075WyHM9KxuJbCCDbOfXGE0z6aUZ2+LmP8h0bUzE/N9S0/s/SRinFA4zbV1Znvn2H/3fMDRziT+mGEqJHlqydYBZ5LnxBq6uyQd8mJ56Ic8P2XQIU9mDD7kqYxkGdOBjPNIcamIbJNuVIqfMkiKzEghRaYNkVKGlPRSFjQWuKruhSOnM01LppMTe0URhtHV3IhTo/IGHBmknHWZk+I7Vq7Oap6r3/hrxCfVdV0FV6Pc9a9lbzwqnnfn1SxnlsWOCC8EX/UH/3jQE3yrJ7jKzBNfcEAhYVEF4WFyxwXKWp07/BvqgnWDtf1L/RUprYr5av6B/OIYsFnssekkxFOY6ERT3FsmXZJefmpigfNVKFLUbnzcN8qYfJ1KMUC2SeRVLszRp/7PJnksBKdVT5DzoPrGQXzsP6OjZFrMxJYE+d85QNS183lBjqkpmucFATnEGuDJTAqQi7Smfk5NwriZBkNWpQFiJMbv8QRWH7MgAAA=";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminPopupUI adminPopupUI = this;
    protected javax.swing.JTabbedPane adminTabs;
    protected com.jurismarches.vradi.ui.admin.AdminThesaurusUI adminThesaurus;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private com.jurismarches.vradi.ui.admin.AdminNavUI $AdminNavUI0;
    private com.jurismarches.vradi.ui.admin.AdminNavUI $AdminNavUI1;
    private com.jurismarches.vradi.ui.admin.AdminNavUI $AdminNavUI2;
    private com.jurismarches.vradi.ui.admin.AdminNavUI $AdminNavUI3;
    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.TabInfo $TabInfo0;
    private jaxx.runtime.swing.TabInfo $TabInfo1;
    private jaxx.runtime.swing.TabInfo $TabInfo2;
    private jaxx.runtime.swing.TabInfo $TabInfo3;
    private jaxx.runtime.swing.TabInfo $TabInfo4;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean contextInitialized;
    private SingleSelectionModel selectionModel;
    
    
    public  AdminPopupUI(JAXXContext parentContext, Window parent) {
        super(parent);$initialize();
    
        SwingUtil.initContext(this, parentContext);
        getHandler().createModel(this);
        jaxx.runtime.Util.assignment(selectionModel = new DefaultSingleSelectionModel() {
            private static final long serialVersionUID = 1L;
    
            @Override
            public void setSelectedIndex(int index) {
                int oldIndex = getSelectedIndex();
                if (oldIndex != -1) {
                    // on verifie que l'onglet en cours n'est pas modifie
                    AdminNavUI tab = getCurrentTab();
    
                    // null if is thesaurus selected
                    if (tab == null){
                        AdminHandler handler = getHandler();
                        boolean canContinue = handler.answerToSave(getTesaurusTab());
                        if (!canContinue) {
                            // l'utilisateur ne veut pas partir au final
                            return;
                        }
                    } else {
                        log.debug("current tab to close " + tab.getName());
                        AdminContentUI<?> content = tab.getCurrentContent();
                        boolean canContinue = tab.getHandler().answerToSave(content);
                        if (!canContinue) {
                            // l'utilisateur ne veut pas partir au final
                            return;
                        }
                    }
                }
                super.setSelectedIndex(index);
            }
        }, "selectionModel", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
        jaxx.runtime.Util.assignment(contextInitialized = true, "contextInitialized", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
    $initialize();
    }
    
    public void close(){
        AdminNavUI navSelected = getCurrentTab();
        AdminHandler handler = getHandler();
        // if is thesaurus selected
        if (navSelected == null){
            boolean canContinue = handler.answerToSave(getTesaurusTab());
            if (canContinue) {
                handler.close(this);
            }
            return;
        }
        AdminContentUI currentContent = navSelected.getCurrentContent();
        boolean canContinue = handler.answerToSave(currentContent);
        if (canContinue) {
            handler.close(this);
        }
    }
    
    public void showTab(int i){
        adminTabs.setSelectedIndex(i);
    }
    
    public AdminNavUI getCurrentTab() {
        Component selected = adminTabs.getSelectedComponent();
        if (selected instanceof AdminThesaurusUI) {
            return null;
        }
        return (AdminNavUI) selected;
    }
    
    public AdminThesaurusUI getTesaurusTab(){
        return (AdminThesaurusUI)adminTabs.getComponentAt(4);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public void updateTab(AdminNavUI ui) {
        // If id AdminThesaurus selected
        if (ui != null){
            TreePath path = ui.getNav().getSelectionPath();
            Object old = path == null ? null : path.getLastPathComponent();
    
            getHandler().createModel(this);
            ui.getHelper().createTreeModel();
    
            //NavigationTreeModel treeModel = ui.getHelper().createTreeModel(ui);
            //ui.getNav().setModel(treeModel);
    
            if (old != null && old instanceof NavigationTreeNode) {
                // reselect node (if found)
                NavigationTreeNode node = (NavigationTreeNode) old;
                ui.getHelper().reSelectNode(ui, node.getFullPath());
            }
            ui.open();
        }
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminPopupUI() {
        $initialize();
    }

    public AdminPopupUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doStateChanged__on__adminTabs(javax.swing.event.ChangeEvent event) {
        updateTab(getCurrentTab());
    }

    public void doWindowClosing__on__adminPopupUI(java.awt.event.WindowEvent event) {
        close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTabbedPane getAdminTabs() {
        return adminTabs;
    }

    public com.jurismarches.vradi.ui.admin.AdminThesaurusUI getAdminThesaurus() {
        return adminThesaurus;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.ui.admin.AdminNavUI get$AdminNavUI0() {
        return $AdminNavUI0;
    }

    protected com.jurismarches.vradi.ui.admin.AdminNavUI get$AdminNavUI1() {
        return $AdminNavUI1;
    }

    protected com.jurismarches.vradi.ui.admin.AdminNavUI get$AdminNavUI2() {
        return $AdminNavUI2;
    }

    protected com.jurismarches.vradi.ui.admin.AdminNavUI get$AdminNavUI3() {
        return $AdminNavUI3;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(adminTabs, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
    }

    protected void addChildrenToAdminTabs() {
        if (!allComponentsCreated) {
            return;
        }
        adminTabs.add($AdminNavUI0);
        adminTabs.add($AdminNavUI1);
        adminTabs.add($AdminNavUI2);
        adminTabs.add($AdminNavUI3);
        adminTabs.add(adminThesaurus);
        $TabInfo0.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 0));
        adminTabs.setTitleAt(0, _("vradi.admin.client"));
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 1));
        adminTabs.setTitleAt(1, _("vradi.admin.group"));
        $TabInfo2.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 2));
        adminTabs.setTitleAt(2, _("vradi.admin.form"));
        $TabInfo3.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 3));
        adminTabs.setTitleAt(3, _("vradi.admin.xmlStream"));
        $TabInfo4.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 4));
        adminTabs.setTitleAt(4, _("vradi.admin.thesaurus"));
    }

    protected void createAdminTabs() {
        $objectMap.put("adminTabs", adminTabs = new javax.swing.JTabbedPane());
        adminTabs.setName("adminTabs");
        adminTabs.addChangeListener(Util.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__adminTabs"));
    }

    protected void createAdminThesaurus() {
        $objectMap.put("adminThesaurus", adminThesaurus = new com.jurismarches.vradi.ui.admin.AdminThesaurusUI(this, new ThesaurusTreeHelper(AdminPopupUI.this, getHandler().getRootThesaurus())));
        adminThesaurus.setName("adminThesaurus");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminPopupUI();
        addChildrenToAdminTabs();
        
        // apply 1 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminPopupUI", this);
        createAdminTabs();
        // inline creation of $AdminNavUI0
        $objectMap.put("$AdminNavUI0", $AdminNavUI0 = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new ClientNavigationTreeHelper(this)));
        $AdminNavUI0.setName("$AdminNavUI0");
        // inline creation of $AdminNavUI1
        $objectMap.put("$AdminNavUI1", $AdminNavUI1 = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new GroupNavigationTreeHelper(this)));
        $AdminNavUI1.setName("$AdminNavUI1");
        // inline creation of $AdminNavUI2
        $objectMap.put("$AdminNavUI2", $AdminNavUI2 = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new FormNavigationTreeHelper(this)));
        $AdminNavUI2.setName("$AdminNavUI2");
        // inline creation of $AdminNavUI3
        $objectMap.put("$AdminNavUI3", $AdminNavUI3 = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new XmlStreamNavigationTreeHelper(this)));
        $AdminNavUI3.setName("$AdminNavUI3");
        createAdminThesaurus();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.action.close"));
        $JButton0.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new jaxx.runtime.swing.TabInfo());
        $TabInfo0.setTitle(_("vradi.admin.client"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new jaxx.runtime.swing.TabInfo());
        $TabInfo1.setTitle(_("vradi.admin.group"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new jaxx.runtime.swing.TabInfo());
        $TabInfo2.setTitle(_("vradi.admin.form"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new jaxx.runtime.swing.TabInfo());
        $TabInfo3.setTitle(_("vradi.admin.xmlStream"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new jaxx.runtime.swing.TabInfo());
        $TabInfo4.setTitle(_("vradi.admin.thesaurus"));
        // inline creation of adminPopupUI
        setName("adminPopupUI");
        SwingUtil.setComponentHeight(adminPopupUI,600);
        adminPopupUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.admin.title"));
        SwingUtil.setComponentWidth(adminPopupUI,1024);
        adminPopupUI.addWindowListener(Util.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__adminPopupUI"));
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADMIN_TABS_MODEL, true ,"selectionModel") {
        
            @Override
            public void processDataBinding() {
                adminTabs.setModel(selectionModel);
            }
        });
    }

}