package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_DELETABLE = "deletable";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_THESAURUS_SELECTED_MODEL = "thesaurusSelected.model";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.ThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Form bean;
    protected java.lang.Boolean deletable;
    protected javax.swing.JTree thesaurus;
    protected javax.swing.JList thesaurusSelected;
    protected ThesaurusUI thesaurusUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    ThesaurusTreeHelper helper;
    DefaultListModel thesaurusSelectedModel;
    
    
    public  ThesaurusUI(jaxx.runtime.JAXXContext parentContext, VradiThesaurusDTO rootThesaurus) {
        jaxx.runtime.Util.initContext(this, parentContext);
        this.helper = new ThesaurusTreeHelper(this, rootThesaurus);;
        setContextValue(helper);
    $initialize();
    }
    
    protected ThesaurusHandler getHandler() {
        return getContextValue(ThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        SimpleJAXXObjectBinding sjob = new SimpleJAXXObjectBinding(this, PROPERTY_BEAN, false, "bean"){
            @Override
            public void processDataBinding() {
                if (log.isDebugEnabled()){
                    log.debug("tryToSelect");
                }
                helper.tryToSelect(ThesaurusUI.this, getBean().getThesaurus());
            }
        };
        registerDataBinding(sjob);
        sjob.applyDataBinding();
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
    
                // If node is selected
                boolean isSelected = path != null;
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                    JPopupMenu popup = new JPopupMenu();
    
                    JMenuItem menuAddCriteria = new JMenuItem();
                    menuAddCriteria.setText(_("vradi.menu.addCriteria"));
                    menuAddCriteria.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            addCriteriaSelected(getPathSelected(mouseEvent));
                        }
                    });
                    popup.add(menuAddCriteria);
    
                    JMenuItem menuAddColumns = new JMenuItem();
                    menuAddColumns.setText(_("vradi.menu.addColumns"));
                    menuAddColumns.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            addColumnSelected(getPathSelected(mouseEvent));
                        }
                    });
                    popup.add(menuAddColumns);
    
                    if (isSelected){
                        JMenuItem menuAddThesaurus = new JMenuItem();
                        menuAddThesaurus.setText(_("vradi.menu.addThesaurus"));
                        menuAddThesaurus.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                addThesorusSelected(getPathSelected(mouseEvent));
                            }
                        });
                        popup.add(menuAddThesaurus);
    
                    }
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    
        thesaurus.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                thsaurusSelected();
            }
        });
    }
    
    public DefaultListModel getThesaurusSelectedModel(){
        return thesaurusSelectedModel;
    }
    
    protected void thsaurusSelected(){
        TreePath[] treePaths = thesaurus.getSelectionPaths();
        jaxx.runtime.Util.assignment(thesaurusSelectedModel = new DefaultListModel(), "thesaurusSelectedModel", com.jurismarches.vradi.ui.ThesaurusUI.this);
        if (treePaths != null){
            for (TreePath path : treePaths){
                NavigationTreeNode selected = (NavigationTreeNode)path.getLastPathComponent();
                VradiThesaurusDTO thesaurusSelected = (VradiThesaurusDTO)selected.getBean(this);
                thesaurusSelectedModel.addElement(thesaurusSelected.getBean());
            }
        }
        thesaurusSelected.setModel(thesaurusSelectedModel);
    }
    
    protected TreePath getPathSelected(MouseEvent e){
        // Recuperation de la source
        JTree tree = (JTree) e.getSource();
    
        // Recuperation du path selectionne
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
    
        return path;
    }
    
    protected void addCriteriaSelected(TreePath path){
        log.debug("addCriteriaSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().addCriteria(this, helper, path);
    }
    
    protected void addThesorusSelected(TreePath path){
        log.debug("addThesorusSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().addThesaurus(this, helper, path);
    }
    
    protected void addColumnSelected(TreePath path){
        log.debug("addColumnSelected " + path);
        // Ajout dune nouvelle column
        getHandler().addColumn(this, helper, path);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusUI() {
        $initialize();
    }

    public ThesaurusUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().closeThesaurus(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Form getBean() {
        return bean;
    }

    public java.lang.Boolean getDeletable() {
        return deletable;
    }

    public javax.swing.JTree getThesaurus() {
        return thesaurus;
    }

    public javax.swing.JList getThesaurusSelected() {
        return thesaurusSelected;
    }

    public java.lang.Boolean isDeletable() {
        return deletable !=null && deletable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setDeletable(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.deletable;
        this.deletable = newValue;
        firePropertyChange(PROPERTY_DELETABLE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setBorderPainted(false);
        $JButton0.setFocusPainted(false);
        $JButton0.setHorizontalTextPosition(0);
        $JButton0.setOpaque(true);
        $JButton0.setVerticalAlignment(0);
        $JButton0.setVerticalTextPosition(0);
        $JButton0.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDeletable() {
        $objectMap.put("deletable", deletable = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JTree());
        thesaurus.setName("thesaurus");
        thesaurus.setExpandsSelectedPaths(true);
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(false);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = new javax.swing.JList());
        thesaurusSelected.setName("thesaurusSelected");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurusSelected);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(thesaurus);
        
        // apply 3 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("closeTab"));
        $JButton0.setSize(new Dimension(16, 16));
        thesaurusSelected.setCellRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        thesaurus.setModel(helper.createTreeModel(this));
        thesaurus.setSelectionModel(helper.createTreeHandler(this));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 3 data bindings
        $registerDefaultBindings();
        $objectMap.put("thesaurusUI", this);
        createBean();
        createDeletable();
        thesaurusSelectedModel = new DefaultListModel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        create$JButton0();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurusSelected();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        $JScrollPane1.setName("$JScrollPane1");
        createThesaurus();
        // inline creation of thesaurusUI
        setName("thesaurusUI");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    $JLabel0.setText(_(helper.getRootName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"deletable") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(isDeletable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_SELECTED_MODEL, true ,"thesaurusSelectedModel") {
        
            @Override
            public void processDataBinding() {
                thesaurusSelected.setModel(thesaurusSelectedModel);
            }
        });
    }

}