package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.sharengo.wikitty.TreeNode;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class OfferListUI extends javax.swing.JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADVENCED_SEARCH_COLLAPSED = "advencedSearchCollapsed";
    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.OfferListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean advencedSearchCollapsed;
    protected javax.swing.JTabbedPane editTabs;
    protected javax.swing.JButton exportButton;
    protected javax.swing.JTable listTable;
    protected OfferListUI offerList = this;
    protected com.jurismarches.vradi.ui.OfferListTableModel offerListTableModel;
    protected javax.swing.JPanel paginationPanel;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected javax.swing.JPanel searchPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public OfferListHandler getHandler() {
        return getContextValue(OfferListHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return getContextValue(SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    
        SwingUtil.fixTableColumnWidth(listTable, 2, 60);
    
        // Adding tooltip
        UIHelper.setI18nTableHeaderRenderer(listTable,
                n_("vradi.offer.name"), n_("vradi.offer.name.tip"),
                n_("vradi.offerEdit.datePub"), n_("vradi.offerEdit.datePub.tip"),
                n_("vradi.offer.statut"), n_("vradi.offer.statut.tip"));
    
        OfferListTableModel.OfferListTableCellRenderer renderer =
                new OfferListTableModel.OfferListTableCellRenderer();
        listTable.setDefaultRenderer(String.class, renderer);
        listTable.setDefaultRenderer(Date.class, renderer);
        listTable.setDefaultRenderer(int.class, renderer);
    
        listTable.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    getHandler().selectOffer(offerList);
                }
            }
    
        });
    
        final JTableHeader header = listTable.getTableHeader();
        header.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == MouseEvent.BUTTON1){
                    // Get column selected
                    TableColumnModel columnModel = ((JTableHeader)e.getSource()).getColumnModel();
                    int columnIndex = columnModel.getColumnIndexAtX(e.getX());
                    TableColumn column = columnModel.getColumn(columnIndex);
    
                    final String name = offerListTableModel.getFieldNameAt(columnIndex);
                    offerListTableModel.setAscending(!offerListTableModel.isAscending());
                    offerListTableModel.setFieldToSort(name);
                    log.debug(offerListTableModel.getFieldToSort() + " " + offerListTableModel.isAscending());
    
                    /*column.setHeaderRenderer(new DefaultTableCellRenderer() {
    
                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value,
                                boolean isSelected, boolean hasFocus, int row, int column) {
                            //setUI(header.getUI());
                            setForeground(header.getForeground());
                            setBackground(header.getBackground());
                            setFont(header.getFont());
                            setText(value == null ? "" : name);
                            setIcon(jaxx.runtime.Util.getUIManagerActionIcon("site"));
                            setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                            setHorizontalAlignment(JLabel.CENTER);
                            return this;
                        }
                    });*/
    
                    getSearchHandler().executeQuery(offerList);
                } else if (e.getButton() == MouseEvent.BUTTON3){
    
                    // Get column selected
                    TableColumnModel columnModel = ((JTableHeader)e.getSource()).getColumnModel();
                    int columnIndex = columnModel.getColumnIndexAtX(e.getX());
                    TableColumn column = columnModel.getColumn(columnIndex);
    
                    if (columnIndex > 2){
                        final String name = (String)column.getHeaderValue();
    
                        // Popup
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem menuRemoveCriteria = new JMenuItem();
                        menuRemoveCriteria.setText(_("vradi.menu.removeColumn"));
                        menuRemoveCriteria.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                removeColumn(name);
                            }
                        });
                        popup.add(menuRemoveCriteria);
    
                        // Show
                        popup.show(listTable, e.getX(), e.getY());
    
                    }
    
                }
            }
        });
    
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "offerListTableModel", offerListTableModel) {
    
           @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                    getSearchHandler().executeQuery(offerList);
                    setCursor(null);
                }
            }
    
        };
      
        registerDataBinding(djb);
        djb.applyDataBinding();
    
        validate();
    }
    
    protected void removeColumn(String name){
        OfferListTableModel model = (OfferListTableModel)listTable.getModel();
        TreeNode thesaurus = model.getThesaurusByName(name);
        getHandler().removeColumn(OfferListUI.this, thesaurus);
    }
    
    public void updateTableModel(){
        setOfferListTableModel(getHandler().getOfferListTableModel());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferListUI() {
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__exportButton(java.awt.event.ActionEvent event) {
        getSearchHandler().exportToCSV(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getAdvencedSearchCollapsed() {
        return advencedSearchCollapsed;
    }

    public javax.swing.JTabbedPane getEditTabs() {
        return editTabs;
    }

    public javax.swing.JButton getExportButton() {
        return exportButton;
    }

    public javax.swing.JTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JPanel getPaginationPanel() {
        return paginationPanel;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public java.lang.Boolean isAdvencedSearchCollapsed() {
        return advencedSearchCollapsed !=null && advencedSearchCollapsed;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAdvencedSearchCollapsed(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.advencedSearchCollapsed;
        this.advencedSearchCollapsed = newValue;
        firePropertyChange(PROPERTY_ADVENCED_SEARCH_COLLAPSED, oldValue, newValue);
    }

    public void setOfferListTableModel(com.jurismarches.vradi.ui.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, JSplitPane.LEFT);
        add(editTabs, JSplitPane.RIGHT);
    }

    protected void addChildrenToPaginationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        paginationPanel.add(exportButton, BorderLayout.SOUTH);
        paginationPanel.add(paginationUI, BorderLayout.NORTH);
    }

    protected void createAdvencedSearchCollapsed() {
        $objectMap.put("advencedSearchCollapsed", advencedSearchCollapsed = false);
    }

    protected void createEditTabs() {
        $objectMap.put("editTabs", editTabs = new javax.swing.JTabbedPane());
        editTabs.setName("editTabs");
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new javax.swing.JButton());
        exportButton.setName("exportButton");
        exportButton.setText(_("vradi.export.cvs"));
        exportButton.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__exportButton"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new javax.swing.JTable());
        listTable.setName("listTable");
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createPaginationPanel() {
        $objectMap.put("paginationPanel", paginationPanel = new javax.swing.JPanel());
        paginationPanel.setName("paginationPanel");
        paginationPanel.setLayout(new BorderLayout());
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        paginationUI.setName("paginationUI");
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferList();
        // inline complete setup of $JPanel0
        $JPanel0.add(searchPanel, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationPanel, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listTable);
        addChildrenToPaginationPanel();
        
        // apply 11 property setters
        setDividerLocation(Integer.MAX_VALUE);
        setDividerSize(0);
        setOrientation(JSplitPane.VERTICAL_SPLIT);
        setResizeWeight(1);
        offerListTableModel.setNbFormsPerPage(10);
        offerListTableModel.setPageToShow(1);
        listTable.setAutoResizeMode(2);
        listTable.setModel(offerListTableModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerList", this);
        createOfferListTableModel();
        createAdvencedSearchCollapsed();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSearchPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createListTable();
        createPaginationPanel();
        createExportButton();
        createPaginationUI();
        createEditTabs();
        // inline creation of offerList
        setName("offerList");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        
        $completeSetup();
    }

}