/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;

public class MissingStringLastComparatorSource
implements SortComparatorSource {
    public static final String bigString = "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffNULL_VAL";
    private final String missingValueProxy;

    public MissingStringLastComparatorSource() {
        this(bigString);
    }

    public MissingStringLastComparatorSource(String missingValueProxy) {
        this.missingValueProxy = missingValueProxy;
    }

    public ScoreDocComparator newComparator(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final FieldCache.StringIndex index = FieldCache.DEFAULT.getStringIndex(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                int fi = index.order[i.doc];
                int fj = index.order[j.doc];
                if (fi == fj) {
                    return 0;
                }
                if (fi == 0) {
                    return 1;
                }
                if (fj == 0) {
                    return -1;
                }
                return fi < fj ? -1 : 1;
            }

            public Comparable sortValue(ScoreDoc i) {
                int f = index.order[i.doc];
                return 0 == f ? MissingStringLastComparatorSource.this.missingValueProxy : index.lookup[f];
            }

            public int sortType() {
                return 9;
            }
        };
    }
}

