/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.services.managers.BindingManager;
import com.jurismarches.vradi.services.managers.ClientManager;
import com.jurismarches.vradi.services.managers.FormManager;
import com.jurismarches.vradi.services.managers.FormTypeManager;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.search.Search;

public class VradiStorageServiceImpl
implements VradiStorageService {
    private static final Log log = LogFactory.getLog(VradiStorageServiceImpl.class);
    protected WikittyProxy proxy = ServiceHelper.getWikittyProxy();
    protected ThesaurusManager thesaurusManager = new ThesaurusManager(this.proxy);
    protected BindingManager bindingManager;
    protected FormManager formManager;
    protected FormTypeManager formTypeManager;
    protected ClientManager clientManager = new ClientManager(this.proxy);
    protected SearchManager searchManager;
    public static final SimpleDateFormat FORM_ID_DATE_FORMAT = FormManager.FORM_ID_DATE_FORMAT;
    public static final String DEFAULT_SENDING_PARAGRAPH = "null";

    public VradiStorageServiceImpl() {
        this.formTypeManager = new FormTypeManager(this.proxy);
        this.searchManager = new SearchManager(this.proxy, this.clientManager);
        this.formManager = new FormManager(this.proxy, this.clientManager, this.thesaurusManager, this.searchManager);
        this.bindingManager = new BindingManager(this.proxy, this.formTypeManager, this.formManager);
    }

    @Override
    public BusinessEntity getEntity(String id, Class<? extends BusinessEntity> clazz) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getEntity(" + id + ", " + clazz.getSimpleName() + ")"));
        }
        BusinessEntity entity = this.proxy.restore(clazz, id);
        return entity;
    }

    @Override
    public BusinessEntity updateEntity(BusinessEntity entity) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateEntity(entity)");
        }
        if (entity != null) {
            entity = this.proxy.store(entity);
            return entity;
        }
        return null;
    }

    @Override
    public void deleteEntity(BusinessEntity entity) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"deleteEntity(entity)");
        }
        if (entity != null) {
            this.proxy.delete(entity.getWikittyId());
        }
    }

    @Override
    public User getUser(String userId) throws TechnicalException {
        return this.clientManager.getUser(userId);
    }

    @Override
    public Client getClient(String clientId) throws TechnicalException {
        return this.clientManager.getClient(clientId);
    }

    @Override
    public Group getGroup(String groupId) throws TechnicalException {
        return this.clientManager.getGroup(groupId);
    }

    @Override
    public List<User> getGroupUsers(String groupId) throws TechnicalException {
        return this.clientManager.getGroupUsers(groupId);
    }

    @Override
    public List<User> getClientUsers(String clientId) throws TechnicalException {
        return this.clientManager.getClientUsers(clientId);
    }

    @Override
    public List<Client> getGroupClients(String groupId) throws TechnicalException {
        return this.clientManager.getGroupClients(groupId);
    }

    @Override
    public Client getClientByUserId(String userId) throws TechnicalException {
        return this.clientManager.getClientByUserId(userId);
    }

    @Override
    public List<Group> getGroupsByUserId(String userId) throws TechnicalException {
        return this.clientManager.getGroupsByUserId(userId);
    }

    @Override
    public List<Group> getGroupsByClientId(String clientId) throws TechnicalException {
        return this.clientManager.getGroupsByClientId(clientId);
    }

    @Override
    public List<Client> getAllClients() throws TechnicalException {
        return this.clientManager.getAllClients();
    }

    @Override
    public List<User> getAllUsers() throws TechnicalException {
        return this.clientManager.getAllUsers();
    }

    @Override
    public List<Group> getAllGroups() throws TechnicalException {
        return this.clientManager.getAllGroups();
    }

    @Override
    public Form updateForm(Form form) throws TechnicalException {
        return this.formManager.updateForm(form);
    }

    @Override
    public List<Form> updateForms(List<Form> forms) throws TechnicalException {
        return this.formManager.updateForms(forms);
    }

    @Override
    public void findForms(String query, VradiFormPageDTO formPageDTO) throws UnsupportedQueryException {
        this.findForms(query, null, null, null, null, null, formPageDTO);
    }

    @Override
    public void findForms(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List<String>[] thesaurus, VradiFormPageDTO formPageDTO) throws UnsupportedQueryException {
        this.searchManager.findForms(query, extension, dateType, beginDate, endDate, thesaurus, formPageDTO);
    }

    @Override
    public List<String> getQueriesReturningForm(Form form) throws TechnicalException {
        return this.searchManager.getQueriesReturningForm(form);
    }

    @Override
    public List<WikittyExtension> getAllFormTypes() {
        return this.formTypeManager.getAllFormTypes();
    }

    @Override
    public WikittyExtension getFormType(String name) {
        return this.formTypeManager.getFormType(name);
    }

    @Override
    public Map<String, FieldType> getFormTypeFields(String name) {
        return this.formTypeManager.getFormTypeFields(name);
    }

    @Override
    public WikittyExtension updateFormType(String name, Map<String, FieldType> fields, String requires, Map<String, String> tagValues) {
        return this.formTypeManager.updateFormType(name, fields, requires, tagValues);
    }

    @Override
    public WikittyExtension updateFormType(WikittyExtension extension) {
        return this.formTypeManager.updateFormType(extension);
    }

    @Override
    public Form getForm(String formId) {
        return this.formManager.getForm(formId);
    }

    @Override
    public void deleteForm(String formId) {
        this.formManager.deleteForm(formId);
    }

    @Override
    public List<Form> getForms(List<String> formIds) {
        return this.formManager.getForms(formIds);
    }

    @Override
    public List<Form> getAllForms() {
        return this.formManager.getAllForms();
    }

    @Override
    public List<XmlStream> getAllXmlStreams() {
        return this.bindingManager.getAllXmlStreams();
    }

    @Override
    public List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> bindings) {
        return this.bindingManager.updateXmlFieldBindings(bindings);
    }

    @Override
    public XmlStream getXmlStream(String xmlStreamId) throws TechnicalException {
        return this.bindingManager.getXmlStream(xmlStreamId);
    }

    @Override
    public XmlFieldBinding getXmlFieldBinding(String xmlFieldBindingId) {
        return this.bindingManager.getXmlFieldBinding(xmlFieldBindingId);
    }

    @Override
    public List<XmlFieldBinding> getXmlFieldBindings(XmlStream xmlStream) {
        return this.bindingManager.getXmlFieldBindings(xmlStream);
    }

    @Override
    public void bindFormsToClients() {
        this.formManager.bindFormsToClients();
    }

    @Override
    public List<VradiSendingDTO> getFormsByClients(String dateType, Date beginDate, Date endDate, WikittyExtension extension, Boolean receptionProof, Boolean paragraph, int status) throws TechnicalException {
        return this.formManager.getFormsByClients(dateType, beginDate, endDate, extension, receptionProof, paragraph, status);
    }

    @Override
    public Map<Form, List<Client>> getClientsByForms(String dateType, Date beginDate, Date endDate, WikittyExtension extension) {
        return this.formManager.getClientsByForms(dateType, beginDate, endDate, extension);
    }

    @Override
    public Object[] getFormsFromXmlStream(XmlStream xmlStream, String lastItemRecorded, VradiUser vradiUser) throws TechnicalException {
        return this.bindingManager.getFormsFromXmlStream(xmlStream, lastItemRecorded, vradiUser);
    }

    @Override
    public VradiUser updateVradiUser(VradiUser vradiUser) throws TechnicalException {
        Search search;
        Criteria criteria;
        PagedResult users;
        List result;
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateVradiUser(vradiUser)");
        }
        if ((result = (users = this.proxy.findAllByCriteria(VradiUser.class, criteria = (search = Search.query().eq("VradiUser.name", vradiUser.getName())).criteria())).getAll()).size() > 0) {
            log.debug((Object)("user " + vradiUser + " already exists"));
            return null;
        }
        return (VradiUser)this.proxy.store((BusinessEntity)vradiUser);
    }

    @Override
    public VradiUser logVradiUser(String vradiUserName, String vradiUserPassword) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("logVradiUser(" + vradiUserName + ", " + vradiUserPassword + ")"));
        }
        Criteria criteria = Search.query().eq("VradiUser.name", vradiUserName).eq("VradiUser.password", vradiUserPassword).criteria();
        VradiUser vradiUser = (VradiUser)this.proxy.findByCriteria(VradiUser.class, criteria);
        return vradiUser;
    }

    @Override
    public void updateSendings(List<Sending> sendings) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateSendings(sendings)");
        }
        this.proxy.store(sendings);
    }

    @Override
    public void importData(File file) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"importData(file)");
        }
        String toURI = file.toURI().toString();
        log.info((Object)("importing file: " + toURI));
        this.proxy.syncImportFromUri(toURI);
        log.info((Object)"import done");
    }

    @Override
    public String exportData() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"exportData()");
        }
        log.info((Object)"exporting all data");
        try {
            Search search = Search.query().keyword("*");
            Criteria criteria = search.criteria();
            String export = this.proxy.syncExportAllByCriteria(criteria);
            log.info((Object)"export done");
            return export;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new TechnicalException((Throwable)e);
        }
    }

    @Override
    public void reindexData() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"reindexData()");
        }
        UpdateResponse response = this.proxy.getWikittyService().syncEngin();
        if (log.isDebugEnabled()) {
            log.debug((Object)response.toString());
        }
    }

    @Override
    public void changeDataDir(String newDataDir, String oldDataDir) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("changeDataDir(" + newDataDir + ", " + oldDataDir + ")"));
        }
        this.proxy.changeDataDir(newDataDir, oldDataDir);
    }

    @Override
    public TreeNode getRootThesaurus() throws TechnicalException {
        return this.thesaurusManager.getRootThesaurus();
    }

    @Override
    public List<TreeNode> getAllThesaurus() throws TechnicalException {
        return this.thesaurusManager.getAllThesaurus();
    }

    @Override
    public TreeNode getThesaurus(String thesaurusId) throws TechnicalException {
        return this.thesaurusManager.getThesaurus(thesaurusId);
    }

    @Override
    public List<TreeNode> getChildrenThesaurus(String thesaurusId) throws TechnicalException {
        return this.thesaurusManager.getChildrenThesaurus(thesaurusId);
    }

    @Override
    public Map<TreeNode, Integer> getNbFormsByThesaurus() throws TechnicalException {
        return this.thesaurusManager.getNbFormsByThesaurus();
    }

    @Override
    public int getNbFormsForThesaurus(String thesaurusId) throws TechnicalException {
        return this.thesaurusManager.getNbFormsForThesaurus(thesaurusId);
    }

    @Override
    public Status getStatus(String statusId) throws TechnicalException {
        return this.formManager.getStatus(statusId);
    }

    @Override
    public List<Status> getStatuses(List<String> statusIds) throws TechnicalException {
        return this.formManager.getStatuses(statusIds);
    }

    @Override
    public List<Status> getAllStatuses() throws TechnicalException {
        return this.formManager.getAllStatuses();
    }

    @Override
    public Status updateStatus(Status status) throws TechnicalException {
        return this.formManager.updateStatus(status);
    }

    @Override
    public List<Status> updateStatuses(List<Status> statuses) throws TechnicalException {
        return this.formManager.updateStatuses(statuses);
    }

    @Override
    public void deleteStatus(String statusId) throws TechnicalException {
        List<String> statusIds = Arrays.asList(statusId);
        this.formManager.deleteStatuses(statusIds);
    }

    @Override
    public void deleteStatuses(List<String> statusIds) throws TechnicalException {
        this.formManager.deleteStatuses(statusIds);
    }

    @Override
    public Status getToTreatStatus() {
        return this.formManager.getToTreatStatus();
    }

    @Override
    public Status getValidatedStatus() {
        return this.formManager.getValidatedStatus();
    }

    @Override
    public List<TreeNode> proposeThesaurus(Form form, List<TreeNode> thesaurus) throws TechnicalException {
        return this.thesaurusManager.proposeThesaurus(form, thesaurus);
    }
}

