/*
 * *##% 
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.managers;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.ServiceHelper;

/**
 * Class that contains the methods to retrieve the information
 * related to the clients
 * 
 * @author schorlet
 * @date 2010-01-22 20:18:29
 * @version $Revision: 457 $ $Date: 2010-02-02 17:16:38 +0100 (mar., 02 févr. 2010) $
 */
public class ClientManager {
    private static final Log log = LogFactory.getLog(BindingManager.class);

    private final WikittyProxy proxy;
    
    public ClientManager(WikittyProxy proxy) {
        this.proxy = proxy;
    }

    public ClientManager() {
        proxy = ServiceHelper.getWikittyProxy();
    }
    
    public User getUser(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getUser(" + userId + ")");
        }
        
        User user = proxy.restore(User.class, userId);
        return user;
    }

    public Client getClient(String clientId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getClient(" + clientId + ")");
        }
        
        Client client = proxy.restore(Client.class, clientId);
        return client;
    }

    public Group getGroup(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getGroup(" + groupId + ")");
        }
        
        Group group = proxy.restore(Group.class, groupId);
        return group;
    }

    public List<User> getGroupUsers(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getGroupUsers(" + groupId + ")");
        }
        
        List<User> users = new ArrayList<User>();
        Group group = getGroup(groupId);
        
        if (group != null && group.getUser() != null) {
            ArrayList<String> userIds = new ArrayList<String>(group.getUser());
            List<User> restore = proxy.restore(User.class, userIds);
            users.addAll(restore);
        }
        
        return users;
    }

    public List<User> getClientUsers(String clientId)
            throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getClientUsers(" + clientId + ")");
        }
        
        List<User> users = new ArrayList<User>();
        Client client = getClient(clientId);
        
        if (client != null && client.getUser() != null) {
            ArrayList<String> userIds = new ArrayList<String>(client.getUser());
            List<User> restore = proxy.restore(User.class, userIds);
            users.addAll(restore);
        }
        
        return users;
    }

    public List<Client> getGroupClients(String groupId)
            throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getGroupClients(" + groupId + ")");
        }
        
        List<Client> clients = new ArrayList<Client>();
        Group group = getGroup(groupId);
        
        if (group != null && group.getClient() != null) {
            ArrayList<String> clientIds = new ArrayList<String>(group.getClient());
            List<Client> restore = proxy.restore(Client.class, clientIds);
            clients.addAll(restore);
        }
        
        return clients;
    }

    public Client getClientByUserId(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getClientByUserId(" + userId + ")");
        }
        
        User user = getUser(userId);
        String clientId = user.getClient();
        
        return getClient(clientId);
    }

    public List<Group> getGroupsByUserId(String userId)
            throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getGroupsByUserId(" + userId + ")");
        }
        
        List<Group> groups = new ArrayList<Group>();
        User user = getUser(userId);
        
        if (user != null && user.getGroup() != null) {
            ArrayList<String> groupIds = new ArrayList<String>(user.getGroup());
            List<Group> restore = proxy.restore(Group.class, groupIds);
            groups.addAll(restore);
        }
        
        return groups;
    }

    public List<Group> getGroupsByClientId(String clientId)
            throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getGroupsByClientId(" + clientId + ")");
        }
        
        List<Group> groups = new ArrayList<Group>();
        Client client = getClient(clientId);
        
        if (client != null && client.getGroup() != null) {
            ArrayList<String> groupIds = new ArrayList<String>(client.getGroup());
            List<Group> restore = proxy.restore(Group.class, groupIds);
            groups.addAll(restore);
        }
        
        return groups;
    }

    public List<Client> getAllClients() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getAllClients()");
        }
        
        Search search = Search.query().eq(Element.ELT_EXTENSION, Client.EXT_CLIENT);
        Criteria criteria = search.criteria();
        
        PagedResult<Client> clients = proxy.findAllByCriteria(Client.class, criteria);
        List<Client> all = clients.getAll();

        return new ArrayList<Client>(all);
    }

    public List<User> getAllUsers() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getAllUsers()");
        }
        
        Search search = Search.query().eq(Element.ELT_EXTENSION, User.EXT_USER);
        Criteria criteria = search.criteria();
        
        PagedResult<User> users = proxy.findAllByCriteria(User.class, criteria);
        List<User> all = users.getAll();
        
        return new ArrayList<User>(all);
    }

    public List<Group> getAllGroups() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getAllGroups()");
        }
        
        Search search = Search.query().eq(Element.ELT_EXTENSION, Group.EXT_GROUP);
        Criteria criteria = search.criteria();
        
        PagedResult<Group> groups = proxy.findAllByCriteria(Group.class, criteria);
        List<Group> all = groups.getAll();
        
        return new ArrayList<Group>(all);
    }

    
}
