/*
 * *##% 
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;

import java.beans.PropertyChangeListener;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:15:58
 */
public interface VradiDTO<E> {//extends BusinessEntity {

    /**
     * Remplit le bean à partir d'un wikitty.
     *
     * @param wikitty le wikitty source
     */
    void fromWikitty(E wikitty);

    /**
     * Remplit le wikitty à partir du bean.
     *
     * @param wikitty le wikitty a remplir
     */
    void toWikitty(E wikitty);

    /**
     * Vide le dto
     */
    void reset();

    /**
     * Ajoute un listener gloable
     *
     * @param listener le listener à ajouter
     */
    void addPropertyChangeListener(PropertyChangeListener listener);

    /**
     * Supprime un listener globable.
     *
     * @param listener le listener à supprimer
     */
    void removePropertyChangeListener(PropertyChangeListener listener);

    /**
     * Ajoute un listener sur la propriété {@code propertyName}
     *
     * @param propertyName le nom de la propriété
     * @param listener     le listener à ajouter
     */
    void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);

    /**
     * Supprime un listener sur la propriété {@code propertyName}
     *
     * @param propertyName le nom de la propriété
     * @param listener     le listener à supprimer
     */
    void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);


}
