/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.nuiton.util.Resource;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.jdbc.WikittyServiceJDBC;
import org.sharengo.wikitty.solr.WikittySearchEngineSolr;

import com.jurismarches.vradi.migration.Migration004;

/**
 * @author letellier
 */
public class ServiceHelper {
    private static final Log log = LogFactory.getLog(ServiceHelper.class);

    /**
     * Vradi data directory
     */
    public static final String vradiDataDirName = System.getProperty("user.home")
            + File.separator + ".vradi/vradi-0.0.4";
    

    /**
     * single instance of storage service
     */
    private static VradiStorageService vradiStorageService = null;
    /**
     * single instance of xml service
     */
    private static XmlStreamService xmlStreamService = null;

    /**
     * single instance of wikitty proxy
     */
    private static WikittyProxy wikittyProxy = null;

    public static synchronized VradiStorageService getVradiStorageService() {
        if (vradiStorageService == null) {
            vradiStorageService = new VradiStorageServiceImpl();
        }
        return vradiStorageService;
    }

    public static synchronized XmlStreamService getXmlStreamService() {
        if (xmlStreamService == null) {
            xmlStreamService = new XmlStreamServiceImpl();
        }
        return xmlStreamService;
    }

    /**
     * Creates wikitty proxy.
     * creates the vradi data directory and the solr config file if not exists.
     *
     * @return a unique instance of WikittyProxy.
     */
    public static synchronized WikittyProxy getWikittyProxy() {
        if (wikittyProxy == null) {
            checkConfig();

            Logger.getLogger("org.apache.solr").setLevel(Level.WARNING);
            
            WikittyServiceJDBC wikittyService =
                    new WikittyServiceJDBC(vradiDataDirName);
            
            wikittyProxy = new WikittyProxy();
            wikittyProxy.setWikittyService(wikittyService);
            
            Migration004.performMigration();
        }
        
        return wikittyProxy;
    }
    
    /**
     * Initializes solr.data.dir to <code>vradiDataDirName + "/solr/data"</code>.
     * 
     */
    private static void checkConfig() {
        InputStream inputStream = null;
        FileWriter writer = null;
        
        try {
            log.info("Using datadir: " + vradiDataDirName);
            
            File vradiDataDir = new File(vradiDataDirName);
            if (!vradiDataDir.exists()) {
                vradiDataDir.mkdirs();
            }
            
            File userSolrConfig = new File(vradiDataDirName,
                    WikittySearchEngineSolr.SOLRCONFIG);
            
            if (!userSolrConfig.exists()) {
                log.info("Setting solr.data.dir: " + vradiDataDirName + "/solr/data");
                
                URL url = Resource.getURL(WikittySearchEngineSolr.SOLRCONFIG);
                inputStream = url.openStream();
                writer = new FileWriter(userSolrConfig);

                SAXBuilder sxb = new SAXBuilder();
                Document document = sxb.build(inputStream);

                org.jdom.Element racine = document.getRootElement();
                racine.getChild("dataDir").setText("${solr.data.dir:"
                        + vradiDataDirName + "/solr/data}");
                
                XMLOutputter outputter = new XMLOutputter("    ", true);
                outputter.output(document, writer);
            }

        } catch (Exception e) {
            throw new UnhandledException(e);
        } finally {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(writer);
        }
    }
}
