package com.jurismarches.vradi.services;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public interface VradiStorageService {

    // Operation "getEntity"
    BusinessEntity getEntity(String id, Class clazz) throws TechnicalException;

    // Operation "updateEntity"
    BusinessEntity updateEntity(BusinessEntity entity) throws TechnicalException;

    // Operation "deleteEntity"
    void deleteEntity(BusinessEntity entity) throws TechnicalException;

    // Operation "getClient"
    Client getClient(String clientId) throws TechnicalException;

    // Operation "getUser"
    User getUser(String userId) throws TechnicalException;

    // Operation "getGroup"
    Group getGroup(String groupId) throws TechnicalException;

    // Operation "getGroupUsers"
    List<User> getGroupUsers(String groupId) throws TechnicalException;

    // Operation "getClientUsers"
    List<User> getClientUsers(String clientId) throws TechnicalException;

    // Operation "getGroupClients"
    List<Client> getGroupClients(String groupId) throws TechnicalException;

    // Operation "getClientByUserId"
    Client getClientByUserId(String userId) throws TechnicalException;

    // Operation "getGroupsByUserId"
    List<Group> getGroupsByUserId(String userId) throws TechnicalException;

    // Operation "getGroupsByClientId"
    List<Group> getGroupsByClientId(String clientId) throws TechnicalException;

    // Operation "getAllClients"
    List<Client> getAllClients() throws TechnicalException;

    // Operation "getAllGroups"
    List<Group> getAllGroups() throws TechnicalException;

    // Operation "updateXmlFieldBindings"
    List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> bindings) throws TechnicalException;

    // Operation "updateFormType"
    WikittyExtension updateFormType(WikittyExtension ext) throws TechnicalException;

    // Operation "updateFormType"
    WikittyExtension updateFormType(String name, Map<java.lang.String, org.sharengo.wikitty.FieldType> fields, String requires, Map<java.lang.String, java.lang.String> tagValues) throws TechnicalException;

    // Operation "updateForm"
    Form updateForm(Form form) throws TechnicalException;

    // Operation "getXmlStream"
    XmlStream getXmlStream(String xmlStreamId) throws TechnicalException;

    // Operation "getXmlFieldBindings"
    List<XmlFieldBinding> getXmlFieldBindings(XmlStream xmlStream) throws TechnicalException;

    // Operation "getXmlFieldBinding"
    XmlFieldBinding getXmlFieldBinding(String xmlFieldBindingId) throws TechnicalException;

    // Operation "getThesaurus"
    TreeNode getThesaurus(String ThesaurusId) throws TechnicalException;

    // Operation "getRootThesaurus"
    TreeNode getRootThesaurus() throws TechnicalException;

    // Operation "getChildrenThesaurus"
    List<TreeNode> getChildrenThesaurus(String thesaurusId) throws TechnicalException;

    // Operation "getFormTypeFields"
    Map<java.lang.String, org.sharengo.wikitty.FieldType> getFormTypeFields(String name) throws TechnicalException;

    // Operation "getFormType"
    WikittyExtension getFormType(String name) throws TechnicalException;

    // Operation "getForm"
    Form getForm(String formId) throws TechnicalException;

    // Operation "getAllXmlStreams"
    List<XmlStream> getAllXmlStreams() throws TechnicalException;

    // Operation "getAllThesaurus"
    List<TreeNode> getAllThesaurus() throws TechnicalException;

    // Operation "getAllFormTypes"
    List<WikittyExtension> getAllFormTypes() throws TechnicalException;

    // Operation "getAllForms"
    List<Form> getAllForms() throws TechnicalException;

    // Operation "findForms"
    void findForms(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, java.util.List[] theasurus, VradiFormPageDTO formPageDTO) throws TechnicalException;

    // Operation "findForms"
    void findForms(String query, VradiFormPageDTO formPageDTO) throws TechnicalException;

    // Operation "deleteForm"
    void deleteForm(String formId) throws TechnicalException;

    // Operation "bindFormsToClients"
    void bindFormsToClients() throws TechnicalException;

    // Operation "getFormsByClients"
    List<VradiSendingDTO> getFormsByClients(String dateType, Date beginDate, Date endDate, WikittyExtension extension, Boolean receptionProof, Boolean paragraph, int status) throws TechnicalException;

    // Operation "getClientsByForms"
    Map<com.jurismarches.vradi.entities.Form, java.util.List<Client>> getClientsByForms(String dateType, Date beginDate, Date endDate, WikittyExtension extension) throws TechnicalException;

    // Operation "getFormsFromXmlStream"
    String getFormsFromXmlStream(XmlStream xmlStream, String lastItemRecorded, VradiUser vradiUser) throws TechnicalException;

    // Operation "changeDataDir"
    void changeDataDir(String newDataDir, String oldDataDir) throws TechnicalException;

    // Operation "getAllUsers"
    List<User> getAllUsers() throws TechnicalException;

    // Operation "getQueriesReturningForm"
    List<String> getQueriesReturningForm(Form form) throws TechnicalException;

    // Operation "getForms"
    List<Form> getForms(List<String> formIds) throws TechnicalException;

    // Operation "updateVradiUser"
    VradiUser updateVradiUser(VradiUser vradiUser) throws TechnicalException;

    // Operation "logVradiUser"
    VradiUser logVradiUser(String vradiUserName, String vradiUserPassword) throws TechnicalException;

    // Operation "updateSendings"
    void updateSendings(List<Sending> sendings) throws TechnicalException;

    // Operation "importData"
    void importData(File file) throws TechnicalException;

    // Operation "exportData"
    String exportData() throws TechnicalException;

    // Operation "updateForms"
    List<Form> updateForms(List<Form> forms) throws TechnicalException;

    // Operation "reindexData"
    void reindexData() throws TechnicalException;

    // Operation "getNbFormsByThesaurus"
    Map<org.sharengo.wikitty.TreeNode, java.lang.Integer> getNbFormsByThesaurus() throws TechnicalException;

    // Operation "getNbFormsForThesaurus"
    int getNbFormsForThesaurus(String thesaurusId) throws TechnicalException;

} //VradiStorageService
