/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientBean;
import com.jurismarches.vradi.services.dto.VradiDTO;
import java.util.HashSet;

public class VradiClientDTO
extends ClientBean
implements VradiDTO<Client> {
    private static final long serialVersionUID = 1L;

    public VradiClientDTO() {
        this.Client$user = new HashSet();
        this.Client$sending = new HashSet();
        this.QueryMaker$queries = new HashSet();
    }

    @Override
    public void fromWikitty(Client wikitty) {
        if (wikitty == null) {
            this.reset();
        } else {
            this.setWikittyId(wikitty.getWikittyId());
            this.setAddress(wikitty.getAddress());
            this.setContact(wikitty.getContact());
            this.setCreationDate(wikitty.getCreationDate());
            this.setEmail(wikitty.getEmail());
            this.setName(wikitty.getName());
            this.setPhone(wikitty.getPhone());
            this.setValidEmail(wikitty.getValidEmail());
            this.QueryMaker$queries.clear();
            this.addAllQueries(wikitty.getQueries());
            this.Client$user.clear();
            this.addAllUsers(wikitty.getUser());
            this.Client$sending.clear();
            this.addAllSendings(wikitty.getUser());
        }
    }

    @Override
    public void reset() {
        this.setWikittyId(null);
        this.setAddress(null);
        this.setContact(null);
        this.setCreationDate(null);
        this.setEmail(null);
        this.setName(null);
        this.setPhone(null);
        this.setValidEmail(false);
        this.clearQueries();
        this.clearUser();
        this.clearSending();
    }

    @Override
    public void toWikitty(Client wikitty) {
        wikitty.setAddress(this.getAddress());
        wikitty.setContact(this.getContact());
        wikitty.setCreationDate(this.getCreationDate());
        wikitty.setEmail(this.getEmail());
        wikitty.setName(this.getName());
        wikitty.setPhone(this.getPhone());
        wikitty.setValidEmail(this.getValidEmail());
        wikitty.clearSending();
        for (String id : this.getSending()) {
            wikitty.addSending(id);
        }
        wikitty.clearUser();
        for (String id : this.getUser()) {
            wikitty.addUser(id);
        }
        wikitty.clearQueries();
        for (String id : this.getQueries()) {
            wikitty.addQueries(id);
        }
    }

    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        this.propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public void addAllUsers(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                this.Client$user.add(s);
            }
        }
        this.propertyChange.firePropertyChange("user", null, this.Client$user);
    }

    public void addAllSendings(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                this.Client$sending.add(s);
            }
        }
        this.propertyChange.firePropertyChange("sending", null, this.Client$sending);
    }

    public void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                this.QueryMaker$queries.add(s);
            }
        }
        this.propertyChange.firePropertyChange("queries", null, this.QueryMaker$queries);
    }
}

