package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormBean;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 23:11:47
 */
public class VradiFormDTO extends FormBean implements VradiDTO<Form> {

    private static final long serialVersionUID = 1L;

    @Override
    public void fromWikitty(Form wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setDatePeremption(wikitty.getDatePeremption());
            setId(wikitty.getId());
            setName(wikitty.getName());
            setDatePub(wikitty.getDatePub());
        }
    }

    @Override
    public void reset() {
        setWikittyId(null);
        setDatePeremption(null);
        setId(null);
        setName(null);
        setDatePub(null);

    }

    @Override
    public void toWikitty(Form wikitty) {
        wikitty.setDatePeremption(getDatePeremption());
        wikitty.setId(getId());
        wikitty.setName(getName());
        wikitty.setDatePub(getDatePub());
    }


    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }
}
