/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.services.FileService;
import com.jurismarches.vradi.services.FileServiceImpl;
import com.jurismarches.vradi.services.FileServlet;
import com.jurismarches.vradi.services.VradiException;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class FileServlet
extends HttpServlet {
    private static final long serialVersionUID = -5368725458920800210L;
    private static final Log log = LogFactory.getLog(FileServlet.class);
    protected FileService fileService = new FileServiceImpl();

    protected String[] getParametersFormRequestURI(HttpServletRequest request) {
        String params = request.getRequestURI();
        params = StringUtils.removeStart((String)params, (String)request.getContextPath());
        params = StringUtils.removeStart((String)params, (String)request.getServletPath());
        params = StringUtils.removeStart((String)params, (String)"/");
        String[] paramsArray = params.split("/");
        return paramsArray;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        VradiConstants.FileType fileType;
        Object[] paramsArray = this.getParametersFormRequestURI(request);
        String uploadType = paramsArray[0];
        if (log.isDebugEnabled()) {
            log.debug((Object)("Managing download type : " + uploadType));
        }
        if ((fileType = VradiConstants.FileType.valueOf((String)uploadType)) == null) {
            throw new ServletException("Invalid request : unknown upload type : " + uploadType);
        }
        try {
            File file = null;
            switch (1.$SwitchMap$com$jurismarches$vradi$VradiConstants$FileType[fileType.ordinal()]) {
                case 1: {
                    String extensionName = paramsArray[1];
                    String templateName = paramsArray[2];
                    file = this.fileService.downloadTemplate(extensionName, templateName);
                    break;
                }
                case 2: {
                    String uri = paramsArray[1];
                    file = this.fileService.downloadPDF(uri);
                    break;
                }
                case 3: {
                    String uri = paramsArray[1];
                    file = this.fileService.downloadWebHarvestScript(uri);
                    break;
                }
                case 4: {
                    String uri = paramsArray[1];
                    file = this.fileService.downloadFormEmbeddedFile(uri);
                    break;
                }
                case 5: {
                    String uri = paramsArray[1];
                    file = this.fileService.downloadFormAttachment(uri);
                    break;
                }
                case 6: {
                    String uri = paramsArray[1];
                    file = this.fileService.downloadRequestHistory(uri);
                    break;
                }
            }
            if (file != null && file.isFile()) {
                this.goGetFile(request, response, file, fileType);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't find file for params : " + Arrays.toString(paramsArray)));
                }
                response.setStatus(404);
            }
        }
        catch (VradiException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't download file", (Throwable)eee);
            }
            throw new ServletException("Can't download file", (Throwable)eee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void goGetFile(HttpServletRequest request, HttpServletResponse response, File file, VradiConstants.FileType fileType) throws IOException {
        DataInputStream in = null;
        ServletOutputStream output = null;
        try {
            String mimeType;
            output = response.getOutputStream();
            ServletContext context = this.getServletConfig().getServletContext();
            String mimetype = context.getMimeType(file.getName());
            String string = mimeType = mimetype != null ? mimetype : fileType.getMineType();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sent with mime type : " + mimeType));
            }
            response.setContentType(mimeType);
            response.setContentLength((int)file.length());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
            in = new DataInputStream(new FileInputStream(file));
            IOUtils.copy((InputStream)in, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            if (output != null) {
                output.flush();
                output.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        if (output != null) {
            output.flush();
            output.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            String[] paramsArray = this.getParametersFormRequestURI(request);
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            try {
                String uploadType = paramsArray[0];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Managing upload type : " + uploadType));
                }
                VradiConstants.FileType fileType = VradiConstants.FileType.valueOf((String)uploadType);
                List items = upload.parseRequest(request);
                if (items.size() != 1) {
                    throw new ServletException("Invalid request : " + items.size() + " files found !");
                }
                FileItem item = (FileItem)items.get(0);
                String fileName = item.getName();
                File tempDirectory = FileUtil.createTempDirectory((String)"vradi-temp", (String)"");
                File tempFile = new File(tempDirectory, fileName);
                item.write(tempFile);
                String fileUri = null;
                switch (1.$SwitchMap$com$jurismarches$vradi$VradiConstants$FileType[fileType.ordinal()]) {
                    case 1: {
                        String extensionName = paramsArray[1];
                        fileUri = this.fileService.uploadTemplate(tempFile, extensionName);
                        break;
                    }
                    case 3: {
                        fileUri = this.fileService.uploadWebHarvestScript(tempFile);
                        break;
                    }
                    case 5: {
                        String formId = paramsArray[1];
                        fileUri = this.fileService.uploadFormAttachment(tempFile, formId);
                        break;
                    }
                    case 4: {
                        String formId = paramsArray[1];
                        fileUri = this.fileService.uploadFormEmbeddedFile(tempFile, formId);
                        break;
                    }
                    case 2: {
                        throw new ServletException("Forbidden operation");
                    }
                    case 6: {
                        throw new ServletException("Forbidden operation");
                    }
                }
                response.setHeader("fileuri", fileUri);
                FileUtils.deleteDirectory((File)tempDirectory);
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Uploaded file " + fileName + "(" + item.getSize() + "b)" + " saved to " + fileUri));
                return;
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) throw new ServletException("Can't parse uploaded files", (Throwable)ex);
                log.error((Object)"Can't parse uploaded files", (Throwable)ex);
                throw new ServletException("Can't parse uploaded files", (Throwable)ex);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Request is not multipart");
            }
            response.setStatus(400);
        }
    }
}

