package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class XmlFieldBindingHelper extends XmlFieldBindingImpl {

    private static final long serialVersionUID = -278663925L;


    /**
     * This class is not instanciable, it's just helper
     */
    private XmlFieldBindingHelper() {
    }

    static public Set<String> getXmlField(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, String.class);
        return result;
    }

    static public void addXmlField(Wikitty w, String element) {
        w.addToField(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, element);
    }
    
    static public void removeXmlField(Wikitty w, String element) {
        w.removeFromField(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, element);
    }
    
    static public void clearXmlField(Wikitty w) {
        w.clearField(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD);
    }


    static public void setFormField(Wikitty w, String formField) {
        w.setField(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_FORMFIELD, formField);
    }

    static public String getFormField(Wikitty w) {
        String result = w.getFieldAsString(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_FORMFIELD);
        return result;
    }


    static public void setDefaultValue(Wikitty w, String defaultValue) {
        w.setField(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_DEFAULTVALUE, defaultValue);
    }

    static public String getDefaultValue(Wikitty w) {
        String result = w.getFieldAsString(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_DEFAULTVALUE);
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_XMLFIELDBINDING);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD);
            Object f2 = w2.getFieldAsObject(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_FORMFIELD);
            Object f2 = w2.getFieldAsObject(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_FORMFIELD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_DEFAULTVALUE);
            Object f2 = w2.getFieldAsObject(EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_DEFAULTVALUE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //XmlFieldBindingHelper
