package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class UserAbstract extends QueryMakerImpl implements User, QueryMaker {

    private static final long serialVersionUID = 341999971L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionUser =
        new WikittyExtension(EXT_USER, "5.0", QueryMaker.EXT_QUERYMAKER,
		    WikittyUtil.buildFieldMapExtension(
				"String name",
				"String service",
				"String email",
				"Date creationDate",
				"boolean validEmail",
				"String address",
				"String phone",
				"Date inscriptionDate",
				"boolean enable",
				"Wikitty client"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(QueryMakerAbstract.extensions);
        // current after requires ones
        exts.add(extensionUser);

        extensions = Collections.unmodifiableList(exts);
    }

	public UserAbstract() {
		super();
	}

    public UserAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public UserAbstract(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        Object oldValue = getField(EXT_USER, FIELD_USER_NAME);
        getWikitty().setField(EXT_USER, FIELD_USER_NAME, name);
        getPropertyChangeSupport().firePropertyChange(FIELD_USER_NAME, oldValue, name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_USER, FIELD_USER_NAME);
        return result;
    }


    public void setService(String service) {
        Object oldValue = getField(EXT_USER, FIELD_USER_SERVICE);
        getWikitty().setField(EXT_USER, FIELD_USER_SERVICE, service);
        getPropertyChangeSupport().firePropertyChange(FIELD_USER_SERVICE, oldValue, service);
    }

    public String getService() {
        String result = getWikitty().getFieldAsString(EXT_USER, FIELD_USER_SERVICE);
        return result;
    }


    public void setEmail(String email) {
        Object oldValue = getField(EXT_USER, FIELD_USER_EMAIL);
        getWikitty().setField(EXT_USER, FIELD_USER_EMAIL, email);
        getPropertyChangeSupport().firePropertyChange(FIELD_USER_EMAIL, oldValue, email);
    }

    public String getEmail() {
        String result = getWikitty().getFieldAsString(EXT_USER, FIELD_USER_EMAIL);
        return result;
    }


    public void setCreationDate(Date creationDate) {
        Object oldValue = getField(EXT_USER, FIELD_USER_CREATIONDATE);
        getWikitty().setField(EXT_USER, FIELD_USER_CREATIONDATE, creationDate);
        getPropertyChangeSupport().firePropertyChange(FIELD_USER_CREATIONDATE, oldValue, creationDate);
    }

    public Date getCreationDate() {
        Date result = getWikitty().getFieldAsDate(EXT_USER, FIELD_USER_CREATIONDATE);
        return result;
    }


    public void setValidEmail(boolean validEmail) {
        Object oldValue = getField(EXT_USER, FIELD_USER_VALIDEMAIL);
        getWikitty().setField(EXT_USER, FIELD_USER_VALIDEMAIL, validEmail);
        getPropertyChangeSupport().firePropertyChange(FIELD_USER_VALIDEMAIL, oldValue, validEmail);
    }

    public boolean getValidEmail() {
        boolean result = getWikitty().getFieldAsBoolean(EXT_USER, FIELD_USER_VALIDEMAIL);
        return result;
    }


    public void setAddress(String address) {
        Object oldValue = getField(EXT_USER, FIELD_USER_ADDRESS);
        getWikitty().setField(EXT_USER, FIELD_USER_ADDRESS, address);
        getPropertyChangeSupport().firePropertyChange(FIELD_USER_ADDRESS, oldValue, address);
    }

    public String getAddress() {
        String result = getWikitty().getFieldAsString(EXT_USER, FIELD_USER_ADDRESS);
        return result;
    }


    public void setPhone(String phone) {
        Object oldValue = getField(EXT_USER, FIELD_USER_PHONE);
        getWikitty().setField(EXT_USER, FIELD_USER_PHONE, phone);
        getPropertyChangeSupport().firePropertyChange(FIELD_USER_PHONE, oldValue, phone);
    }

    public String getPhone() {
        String result = getWikitty().getFieldAsString(EXT_USER, FIELD_USER_PHONE);
        return result;
    }


    public void setInscriptionDate(Date inscriptionDate) {
        Object oldValue = getField(EXT_USER, FIELD_USER_INSCRIPTIONDATE);
        getWikitty().setField(EXT_USER, FIELD_USER_INSCRIPTIONDATE, inscriptionDate);
        getPropertyChangeSupport().firePropertyChange(FIELD_USER_INSCRIPTIONDATE, oldValue, inscriptionDate);
    }

    public Date getInscriptionDate() {
        Date result = getWikitty().getFieldAsDate(EXT_USER, FIELD_USER_INSCRIPTIONDATE);
        return result;
    }


    public void setEnable(boolean enable) {
        Object oldValue = getField(EXT_USER, FIELD_USER_ENABLE);
        getWikitty().setField(EXT_USER, FIELD_USER_ENABLE, enable);
        getPropertyChangeSupport().firePropertyChange(FIELD_USER_ENABLE, oldValue, enable);
    }

    public boolean getEnable() {
        boolean result = getWikitty().getFieldAsBoolean(EXT_USER, FIELD_USER_ENABLE);
        return result;
    }


    public void setClient(String client) {
        Object oldValue = getField(EXT_USER, FIELD_USER_CLIENT);
        getWikitty().setField(EXT_USER, FIELD_USER_CLIENT, client);
        getPropertyChangeSupport().firePropertyChange(FIELD_USER_CLIENT, oldValue, client);
    }

    public String getClient() {
        String result = getWikitty().getFieldAsString(EXT_USER, FIELD_USER_CLIENT);
        return result;
    }

    public java.util.Set<String> getQueries() {
        java.util.Set<String> result = getWikitty().getFieldAsSet(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, String.class);
        return result;
    }

    public void addQueries(String element) {
        getWikitty().addToField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }
    
    public void removeQueries(String element) {
        getWikitty().removeFromField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }
    
    public void clearQueries() {
        getWikitty().clearField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_NAME);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_SERVICE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_SERVICE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_EMAIL);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_VALIDEMAIL);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_VALIDEMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_ADDRESS);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_ADDRESS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_PHONE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_PHONE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_INSCRIPTIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_INSCRIPTIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_ENABLE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_ENABLE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_CLIENT);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_USER_CLIENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //UserAbstract
