package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

/**
 * Thesaurus extension for {@link TreeNode}.
 *  
 * Changes in this extension :
 * <ul>
 *  <li>4.0 : ajout des contraintes notNull/unique
 *  <li>3.0 : add rootThesaurus : rootThesaurus reference
 *  <li>2.0 : add order field (numeric)
 *  <li>1.0 : intial version
 * </ul>
 */
public class ThesaurusHelper extends ThesaurusImpl {

    private static final long serialVersionUID = 1084227215L;


    /**
     * This class is not instanciable, it's just helper
     */
    private ThesaurusHelper() {
    }

    static public Set<String> getTags(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS, String.class);
        return result;
    }

    static public void addTags(Wikitty w, String element) {
        w.addToField(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS, element);
    }
    
    static public void removeTags(Wikitty w, String element) {
        w.removeFromField(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS, element);
    }
    
    static public void clearTags(Wikitty w) {
        w.clearField(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS);
    }


    static public void setOrder(Wikitty w, int order) {
        w.setField(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ORDER, order);
    }

    static public int getOrder(Wikitty w) {
        int result = w.getFieldAsInt(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ORDER);
        return result;
    }


    static public void setComment(Wikitty w, String comment) {
        w.setField(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_COMMENT, comment);
    }

    static public String getComment(Wikitty w) {
        String result = w.getFieldAsString(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_COMMENT);
        return result;
    }


    static public void setRootThesaurus(Wikitty w, String rootThesaurus) {
        w.setField(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ROOTTHESAURUS, rootThesaurus);
    }

    static public String getRootThesaurus(Wikitty w) {
        String result = w.getFieldAsString(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ROOTTHESAURUS);
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_THESAURUS);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS);
            Object f2 = w2.getFieldAsObject(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ORDER);
            Object f2 = w2.getFieldAsObject(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ORDER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_COMMENT);
            Object f2 = w2.getFieldAsObject(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_COMMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ROOTTHESAURUS);
            Object f2 = w2.getFieldAsObject(EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ROOTTHESAURUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //ThesaurusHelper
