package com.jurismarches.vradi.entities;

import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.TreeNode;

/**
 * Thesaurus extension for {@link TreeNode}.
 *  
 * Changes in this extension :
 * <ul>
 *  <li>4.0 : ajout des contraintes notNull/unique
 *  <li>3.0 : add rootThesaurus : rootThesaurus reference
 *  <li>2.0 : add order field (numeric)
 *  <li>1.0 : intial version
 * </ul>
 */
public interface Thesaurus extends BusinessEntity, TreeNode {

    static final public String EXT_THESAURUS = "Thesaurus";

    static final public String FIELD_THESAURUS_TAGS = "tags";
    static final public String FQ_FIELD_THESAURUS_TAGS = EXT_THESAURUS + ".tags";
    static final public String FIELD_THESAURUS_ORDER = "order";
    static final public String FQ_FIELD_THESAURUS_ORDER = EXT_THESAURUS + ".order";
    static final public String FIELD_THESAURUS_COMMENT = "comment";
    static final public String FQ_FIELD_THESAURUS_COMMENT = EXT_THESAURUS + ".comment";
    static final public String FIELD_THESAURUS_ROOTTHESAURUS = "rootThesaurus";
    static final public String FQ_FIELD_THESAURUS_ROOTTHESAURUS = EXT_THESAURUS + ".rootThesaurus";
    public Set<String> getTags();
    public void addTags(String element);
    public void removeTags(String element);
    public void clearTags();


    public void setOrder(int order);
    public int getOrder();


    public void setComment(String comment);
    public String getComment();


    public void setRootThesaurus(String rootThesaurus);
    public String getRootThesaurus();


} //Thesaurus
