package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class SessionAbstract extends BusinessEntityWikitty implements Session {

    private static final long serialVersionUID = 1999397049L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionSession =
        new WikittyExtension(EXT_SESSION, "", null,
		    WikittyUtil.buildFieldMapExtension(
				"Date sessionDate",
				"Numeric num",
				"Numeric status",
				"String paragraph",
				"Wikitty sending[0-*] unique=true"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionSession);

        extensions = Collections.unmodifiableList(exts);
    }

	public SessionAbstract() {
		super();
	}

    public SessionAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public SessionAbstract(Wikitty wi) {
		super(wi);
	}


    public void setSessionDate(Date sessionDate) {
        Object oldValue = getField(EXT_SESSION, FIELD_SESSION_SESSIONDATE);
        getWikitty().setField(EXT_SESSION, FIELD_SESSION_SESSIONDATE, sessionDate);
        getPropertyChangeSupport().firePropertyChange(FIELD_SESSION_SESSIONDATE, oldValue, sessionDate);
    }

    public Date getSessionDate() {
        Date result = getWikitty().getFieldAsDate(EXT_SESSION, FIELD_SESSION_SESSIONDATE);
        return result;
    }


    public void setNum(int num) {
        Object oldValue = getField(EXT_SESSION, FIELD_SESSION_NUM);
        getWikitty().setField(EXT_SESSION, FIELD_SESSION_NUM, num);
        getPropertyChangeSupport().firePropertyChange(FIELD_SESSION_NUM, oldValue, num);
    }

    public int getNum() {
        int result = getWikitty().getFieldAsInt(EXT_SESSION, FIELD_SESSION_NUM);
        return result;
    }


    public void setStatus(int status) {
        Object oldValue = getField(EXT_SESSION, FIELD_SESSION_STATUS);
        getWikitty().setField(EXT_SESSION, FIELD_SESSION_STATUS, status);
        getPropertyChangeSupport().firePropertyChange(FIELD_SESSION_STATUS, oldValue, status);
    }

    public int getStatus() {
        int result = getWikitty().getFieldAsInt(EXT_SESSION, FIELD_SESSION_STATUS);
        return result;
    }


    public void setParagraph(String paragraph) {
        Object oldValue = getField(EXT_SESSION, FIELD_SESSION_PARAGRAPH);
        getWikitty().setField(EXT_SESSION, FIELD_SESSION_PARAGRAPH, paragraph);
        getPropertyChangeSupport().firePropertyChange(FIELD_SESSION_PARAGRAPH, oldValue, paragraph);
    }

    public String getParagraph() {
        String result = getWikitty().getFieldAsString(EXT_SESSION, FIELD_SESSION_PARAGRAPH);
        return result;
    }

    public Set<String> getSending() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_SESSION, FIELD_SESSION_SENDING, String.class);
        return result;
    }

    public void addSending(String element) {
        getWikitty().addToField(EXT_SESSION, FIELD_SESSION_SENDING, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_SESSION_SENDING, null, getSending());
    }
    
    public void removeSending(String element) {
        getWikitty().removeFromField(EXT_SESSION, FIELD_SESSION_SENDING, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_SESSION_SENDING, null, getSending());
    }
    
    public void clearSending() {
        getWikitty().clearField(EXT_SESSION, FIELD_SESSION_SENDING);
        getPropertyChangeSupport().firePropertyChange(FIELD_SESSION_SENDING, null, getSending());
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SESSION, FIELD_SESSION_SESSIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_SESSION, FIELD_SESSION_SESSIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SESSION, FIELD_SESSION_NUM);
            Object f2 = w2.getFieldAsObject(EXT_SESSION, FIELD_SESSION_NUM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SESSION, FIELD_SESSION_STATUS);
            Object f2 = w2.getFieldAsObject(EXT_SESSION, FIELD_SESSION_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SESSION, FIELD_SESSION_PARAGRAPH);
            Object f2 = w2.getFieldAsObject(EXT_SESSION, FIELD_SESSION_PARAGRAPH);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SESSION, FIELD_SESSION_SENDING);
            Object f2 = w2.getFieldAsObject(EXT_SESSION, FIELD_SESSION_SENDING);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //SessionAbstract
