package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

/**
 * Root thesaurus extension.
 * 
 * Cannot extends Thesaurus due to not-null rootId violation.
 * 
 * History:
 *  * 1.0 : initial version
 */
public class RootThesaurusHelper extends RootThesaurusImpl {

    private static final long serialVersionUID = -117865581L;


    /**
     * This class is not instanciable, it's just helper
     */
    private RootThesaurusHelper() {
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_ROOTTHESAURUS);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;

        return result;
    }

} //RootThesaurusHelper
