package com.jurismarches.vradi.entities;

import java.util.Date;
import org.nuiton.wikitty.BusinessEntity;

/**
 * Modification tag extension.
 * 
 * Changes in this extension:
 * <ul>
 *  <li>2.0 : no change but use major version
 *  <li>1.2 : add "lastStatusModifier" field
 *  <li>1.1 : lastModifier field change type to String
 *  <li>1.0 : initial version
 * </ul>
 */
public interface ModificationTag extends BusinessEntity {

    static final public String EXT_MODIFICATIONTAG = "ModificationTag";

    static final public String FIELD_MODIFICATIONTAG_LASTMODIFIED = "lastModified";
    static final public String FQ_FIELD_MODIFICATIONTAG_LASTMODIFIED = EXT_MODIFICATIONTAG + ".lastModified";
    static final public String FIELD_MODIFICATIONTAG_LASTMODIFIER = "lastModifier";
    static final public String FQ_FIELD_MODIFICATIONTAG_LASTMODIFIER = EXT_MODIFICATIONTAG + ".lastModifier";
    static final public String FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER = "lastStatusModifier";
    static final public String FQ_FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER = EXT_MODIFICATIONTAG + ".lastStatusModifier";

    public void setLastModified(Date lastModified);
    public Date getLastModified();


    public void setLastModifier(String lastModifier);
    public String getLastModifier();


    public void setLastStatusModifier(String lastStatusModifier);
    public String getLastStatusModifier();


} //ModificationTag
