package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class InfogeneAbstract extends BusinessEntityWikitty implements Infogene {

    private static final long serialVersionUID = 45742572L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionInfogene =
        new WikittyExtension(EXT_INFOGENE, "2.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String id",
				"String objet",
				"Date creationDate",
				"String sourceURL",
				"String sourceText",
				"String entity",
				"String country",
				"String department",
				"String description",
				"String tag[0-*] unique=true",
				"Wikitty status"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionInfogene);

        extensions = Collections.unmodifiableList(exts);
    }

	public InfogeneAbstract() {
		super();
	}

    public InfogeneAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public InfogeneAbstract(Wikitty wi) {
		super(wi);
	}


    public void setId(String id) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_ID);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_ID, id);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_ID, oldValue, id);
    }

    public String getId() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_ID);
        return result;
    }


    public void setObjet(String objet) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_OBJET);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_OBJET, objet);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_OBJET, oldValue, objet);
    }

    public String getObjet() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_OBJET);
        return result;
    }


    public void setCreationDate(Date creationDate) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_CREATIONDATE);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_CREATIONDATE, creationDate);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_CREATIONDATE, oldValue, creationDate);
    }

    public Date getCreationDate() {
        Date result = getWikitty().getFieldAsDate(EXT_INFOGENE, FIELD_INFOGENE_CREATIONDATE);
        return result;
    }


    public void setSourceURL(String sourceURL) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_SOURCEURL);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_SOURCEURL, sourceURL);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_SOURCEURL, oldValue, sourceURL);
    }

    public String getSourceURL() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_SOURCEURL);
        return result;
    }


    public void setSourceText(String sourceText) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_SOURCETEXT);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_SOURCETEXT, sourceText);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_SOURCETEXT, oldValue, sourceText);
    }

    public String getSourceText() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_SOURCETEXT);
        return result;
    }


    public void setEntity(String entity) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_ENTITY);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_ENTITY, entity);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_ENTITY, oldValue, entity);
    }

    public String getEntity() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_ENTITY);
        return result;
    }


    public void setCountry(String country) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_COUNTRY);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_COUNTRY, country);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_COUNTRY, oldValue, country);
    }

    public String getCountry() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_COUNTRY);
        return result;
    }


    public void setDepartment(String department) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_DEPARTMENT);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_DEPARTMENT, department);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_DEPARTMENT, oldValue, department);
    }

    public String getDepartment() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_DEPARTMENT);
        return result;
    }


    public void setDescription(String description) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_DESCRIPTION);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_DESCRIPTION, description);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_DESCRIPTION, oldValue, description);
    }

    public String getDescription() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_DESCRIPTION);
        return result;
    }

    public Set<String> getTag() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_INFOGENE, FIELD_INFOGENE_TAG, String.class);
        return result;
    }

    public void addTag(String element) {
        getWikitty().addToField(EXT_INFOGENE, FIELD_INFOGENE_TAG, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_TAG, null, getTag());
    }
    
    public void removeTag(String element) {
        getWikitty().removeFromField(EXT_INFOGENE, FIELD_INFOGENE_TAG, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_TAG, null, getTag());
    }
    
    public void clearTag() {
        getWikitty().clearField(EXT_INFOGENE, FIELD_INFOGENE_TAG);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_TAG, null, getTag());
    }


    public void setStatus(String status) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_STATUS);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_STATUS, status);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_STATUS, oldValue, status);
    }

    public String getStatus() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_STATUS);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_ID);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_ID);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_OBJET);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_OBJET);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_SOURCEURL);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_SOURCEURL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_SOURCETEXT);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_SOURCETEXT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_ENTITY);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_ENTITY);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_COUNTRY);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_COUNTRY);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_DEPARTMENT);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_DEPARTMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_TAG);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_TAG);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_STATUS);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_INFOGENE_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //InfogeneAbstract
