package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class FormAbstract extends InfogeneImpl implements Form, Infogene {

    private static final long serialVersionUID = 592103267L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionForm =
        new WikittyExtension(EXT_FORM, "4.0", Infogene.EXT_INFOGENE,
		    WikittyUtil.buildFieldMapExtension(
				"Date datePub",
				"Date datePeremption",
				"String thesaurus[0-*] unique=true",
				"String files[0-*] unique=true",
				"String attachments[0-*] unique=true",
				"String xmlStream"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(InfogeneAbstract.extensions);
        // current after requires ones
        exts.add(extensionForm);

        extensions = Collections.unmodifiableList(exts);
    }

	public FormAbstract() {
		super();
	}

    public FormAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public FormAbstract(Wikitty wi) {
		super(wi);
	}


    public void setDatePub(Date datePub) {
        Object oldValue = getField(EXT_FORM, FIELD_FORM_DATEPUB);
        getWikitty().setField(EXT_FORM, FIELD_FORM_DATEPUB, datePub);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_DATEPUB, oldValue, datePub);
    }

    public Date getDatePub() {
        Date result = getWikitty().getFieldAsDate(EXT_FORM, FIELD_FORM_DATEPUB);
        return result;
    }


    public void setDatePeremption(Date datePeremption) {
        Object oldValue = getField(EXT_FORM, FIELD_FORM_DATEPEREMPTION);
        getWikitty().setField(EXT_FORM, FIELD_FORM_DATEPEREMPTION, datePeremption);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_DATEPEREMPTION, oldValue, datePeremption);
    }

    public Date getDatePeremption() {
        Date result = getWikitty().getFieldAsDate(EXT_FORM, FIELD_FORM_DATEPEREMPTION);
        return result;
    }

    public Set<String> getThesaurus() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_FORM, FIELD_FORM_THESAURUS, String.class);
        return result;
    }

    public void addThesaurus(String element) {
        getWikitty().addToField(EXT_FORM, FIELD_FORM_THESAURUS, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_THESAURUS, null, getThesaurus());
    }
    
    public void removeThesaurus(String element) {
        getWikitty().removeFromField(EXT_FORM, FIELD_FORM_THESAURUS, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_THESAURUS, null, getThesaurus());
    }
    
    public void clearThesaurus() {
        getWikitty().clearField(EXT_FORM, FIELD_FORM_THESAURUS);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_THESAURUS, null, getThesaurus());
    }

    public Set<String> getFiles() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_FORM, FIELD_FORM_FILES, String.class);
        return result;
    }

    public void addFiles(String element) {
        getWikitty().addToField(EXT_FORM, FIELD_FORM_FILES, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_FILES, null, getFiles());
    }
    
    public void removeFiles(String element) {
        getWikitty().removeFromField(EXT_FORM, FIELD_FORM_FILES, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_FILES, null, getFiles());
    }
    
    public void clearFiles() {
        getWikitty().clearField(EXT_FORM, FIELD_FORM_FILES);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_FILES, null, getFiles());
    }

    public Set<String> getAttachments() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_FORM, FIELD_FORM_ATTACHMENTS, String.class);
        return result;
    }

    public void addAttachments(String element) {
        getWikitty().addToField(EXT_FORM, FIELD_FORM_ATTACHMENTS, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_ATTACHMENTS, null, getAttachments());
    }
    
    public void removeAttachments(String element) {
        getWikitty().removeFromField(EXT_FORM, FIELD_FORM_ATTACHMENTS, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_ATTACHMENTS, null, getAttachments());
    }
    
    public void clearAttachments() {
        getWikitty().clearField(EXT_FORM, FIELD_FORM_ATTACHMENTS);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_ATTACHMENTS, null, getAttachments());
    }


    public void setXmlStream(String xmlStream) {
        Object oldValue = getField(EXT_FORM, FIELD_FORM_XMLSTREAM);
        getWikitty().setField(EXT_FORM, FIELD_FORM_XMLSTREAM, xmlStream);
        getPropertyChangeSupport().firePropertyChange(FIELD_FORM_XMLSTREAM, oldValue, xmlStream);
    }

    public String getXmlStream() {
        String result = getWikitty().getFieldAsString(EXT_FORM, FIELD_FORM_XMLSTREAM);
        return result;
    }


    public void setId(String id) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_ID);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_ID, id);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_ID, oldValue, id);
    }

    public String getId() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_ID);
        return result;
    }


    public void setObjet(String objet) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_OBJET);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_OBJET, objet);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_OBJET, oldValue, objet);
    }

    public String getObjet() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_OBJET);
        return result;
    }


    public void setCreationDate(Date creationDate) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_CREATIONDATE);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_CREATIONDATE, creationDate);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_CREATIONDATE, oldValue, creationDate);
    }

    public Date getCreationDate() {
        Date result = getWikitty().getFieldAsDate(EXT_INFOGENE, FIELD_INFOGENE_CREATIONDATE);
        return result;
    }


    public void setSourceURL(String sourceURL) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_SOURCEURL);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_SOURCEURL, sourceURL);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_SOURCEURL, oldValue, sourceURL);
    }

    public String getSourceURL() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_SOURCEURL);
        return result;
    }


    public void setSourceText(String sourceText) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_SOURCETEXT);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_SOURCETEXT, sourceText);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_SOURCETEXT, oldValue, sourceText);
    }

    public String getSourceText() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_SOURCETEXT);
        return result;
    }


    public void setEntity(String entity) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_ENTITY);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_ENTITY, entity);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_ENTITY, oldValue, entity);
    }

    public String getEntity() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_ENTITY);
        return result;
    }


    public void setCountry(String country) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_COUNTRY);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_COUNTRY, country);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_COUNTRY, oldValue, country);
    }

    public String getCountry() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_COUNTRY);
        return result;
    }


    public void setDepartment(String department) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_DEPARTMENT);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_DEPARTMENT, department);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_DEPARTMENT, oldValue, department);
    }

    public String getDepartment() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_DEPARTMENT);
        return result;
    }


    public void setDescription(String description) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_DESCRIPTION);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_DESCRIPTION, description);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_DESCRIPTION, oldValue, description);
    }

    public String getDescription() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_DESCRIPTION);
        return result;
    }

    public Set<String> getTag() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_INFOGENE, FIELD_INFOGENE_TAG, String.class);
        return result;
    }

    public void addTag(String element) {
        getWikitty().addToField(EXT_INFOGENE, FIELD_INFOGENE_TAG, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_TAG, null, getTag());
    }
    
    public void removeTag(String element) {
        getWikitty().removeFromField(EXT_INFOGENE, FIELD_INFOGENE_TAG, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_TAG, null, getTag());
    }
    
    public void clearTag() {
        getWikitty().clearField(EXT_INFOGENE, FIELD_INFOGENE_TAG);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_TAG, null, getTag());
    }


    public void setStatus(String status) {
        Object oldValue = getField(EXT_INFOGENE, FIELD_INFOGENE_STATUS);
        getWikitty().setField(EXT_INFOGENE, FIELD_INFOGENE_STATUS, status);
        getPropertyChangeSupport().firePropertyChange(FIELD_INFOGENE_STATUS, oldValue, status);
    }

    public String getStatus() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, FIELD_INFOGENE_STATUS);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_DATEPUB);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_DATEPUB);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_DATEPEREMPTION);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_DATEPEREMPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_THESAURUS);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_THESAURUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_FILES);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_FILES);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_ATTACHMENTS);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_ATTACHMENTS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_XMLSTREAM);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, FIELD_FORM_XMLSTREAM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //FormAbstract
