/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.entities;

import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class EntityHelper {

    /**
     * @deprecated : add method into entity generation template to add property change ?
     * User: sletellier
     */
    @Deprecated
    public static BusinessEntity addModificationTagsIfNecessary(BusinessEntity bean){
        if (bean == null) {
            return null;
        }
        if(!bean.getExtensionNames().contains(ModificationTag.EXT_MODIFICATIONTAG)) {
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty) bean;
            entityWikitty.getWikitty().addExtension(ModificationTagImpl.extensionModificationTag);
        }
        return bean;
    }

    /**
     * @deprecated : add method into entity generation template to add property change ?
     * User: sletellier
     */
    @Deprecated
    public static Date getLastModified(BusinessEntity bean) {
        if (bean == null) {
            return null;
        }
        return (Date) bean.getField(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED);
    }

    /**
     * @deprecated : add method into entity generation template to add property change ?
     * User: sletellier
     */
    @Deprecated
    public static void setLastModified(BusinessEntity bean, Date lastModified) {
        if (bean == null) {
            return;
        }
        bean.setField(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED, lastModified);
    }

    /**
     * @deprecated : add method into entity generation template to add property change ?
     * User: sletellier
     */
    @Deprecated
    public static String getLastModifier(BusinessEntity bean) {
        if (bean == null) {
            return null;
        }
        return (String) bean.getField(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER);
    }

    /**
     * @deprecated : add method into entity generation template to add property change ?
     * User: sletellier
     */
    @Deprecated
    public static void setLastModifier(BusinessEntity bean, String lastModifier) {
        if (bean == null) {
            return;
        }
        bean.setField(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER, lastModifier);
    }


    /**
     * To cast stream as real, if its webHarvest stream, this method while cast as HebArvestStream
     *
     * @param stream to cast
     */
    public static XmlStream castAsRealStream(XmlStream stream) {
        XmlStreamImpl impl = (XmlStreamImpl)stream;

        XmlStream result = null;

        Collection<String> extensionNames = stream.getExtensionNames();
        if (extensionNames.contains(WebHarvestStream.EXT_WEBHARVESTSTREAM)) {
            result = new WebHarvestStreamImpl(impl.getWikitty());

        } else if (extensionNames.contains(XmlStream.EXT_XMLSTREAM)) {
            result = new XmlStreamImpl(impl.getWikitty());
        }
        return result;
    }

    /**
     * To cast stream as real, if its webHarvest stream, this method while cast as HebArvestStream
     *
     * @param streams to cast
     */
    public static List<XmlStream> castAsRealStreams(List<XmlStream> streams) {
        List<XmlStream> result = new ArrayList<XmlStream>();
        for (XmlStream stream : streams) {
            result.add(castAsRealStream(stream));
        }
        return result;
    }

    /**
     * @deprecated use EntityHelper.cast()
     */
    @Deprecated
    public static QueryMaker castAsRealQueryMaker(QueryMaker queryMaker) {
        QueryMakerImpl impl = (QueryMakerImpl) queryMaker;
        QueryMaker result = null;

        Collection<String> extensionNames = impl.getExtensionNames();
        if (extensionNames.contains(Client.EXT_CLIENT)) {
            result = new ClientImpl(impl.getWikitty());

        } else if (extensionNames.contains(User.EXT_USER)) {
            result = new UserImpl(impl.getWikitty());

        } else if (extensionNames.contains(Group.EXT_GROUP)) {
            result = new GroupImpl(impl.getWikitty());
        }

        return result;
    }
}
