/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.time;

import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;

public abstract class TemporalAccessConverter<T extends Temporal>
extends DefaultObjectConverter<T> {
    public static final String PROPERTY_DATE_TIME_FORMATTER = "DateTimeFormatter";
    private DateTimeFormatter _defaultFormatter = null;

    @Override
    public synchronized String toString(T value, ConverterContext context) {
        Object formatter;
        if (value == null) {
            return "";
        }
        Object object = formatter = context != null ? context.getProperties().get((Object)PROPERTY_DATE_TIME_FORMATTER) : null;
        if (formatter instanceof DateTimeFormatter) {
            return ((DateTimeFormatter)formatter).format((TemporalAccessor)value);
        }
        return this.getDefaultDateTimeFormatter().format((TemporalAccessor)value);
    }

    public synchronized TemporalAccessor temporalFromString(String string, ConverterContext context) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            Object formatter;
            Object object = formatter = context != null ? context.getProperties().get((Object)PROPERTY_DATE_TIME_FORMATTER) : null;
            if (formatter instanceof DateTimeFormatter) {
                return ((DateTimeFormatter)formatter).parse(string);
            }
            return this.getDefaultDateTimeFormatter().parse(string);
        }
        catch (Exception e1) {
            try {
                return this.getShortDateTimeFormatter().parse(string);
            }
            catch (Exception e2) {
                try {
                    return this.getMediumDateTimeFormatter().parse(string);
                }
                catch (Exception e3) {
                    try {
                        return this.getLongDateTimeFormatter().parse(string);
                    }
                    catch (Exception e4) {
                        try {
                            return this.getFullDateTimeFormatter().parse(string);
                        }
                        catch (Exception e5) {
                            return null;
                        }
                    }
                }
            }
        }
    }

    protected abstract DateTimeFormatter getFullDateTimeFormatter();

    protected abstract DateTimeFormatter getLongDateTimeFormatter();

    protected abstract DateTimeFormatter getMediumDateTimeFormatter();

    protected abstract DateTimeFormatter getShortDateTimeFormatter();

    public DateTimeFormatter getDefaultDateTimeFormatter() {
        return this._defaultFormatter;
    }

    public void setDefaultDateTimeFormatter(DateTimeFormatter defaultFormat) {
        this._defaultFormatter = defaultFormat;
    }
}

