/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.time;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.time.TemporalAccessConverter;

public class LocalDateTimeConverter
extends TemporalAccessConverter<LocalDateTime> {
    private static final DateTimeFormatter _defaultFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
    private static final DateTimeFormatter _shortFormat = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.SHORT);
    private static final DateTimeFormatter _mediumFormat = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM);
    private static final DateTimeFormatter _longFormat = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.LONG);
    private static final DateTimeFormatter _fullFormat = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.FULL);

    public LocalDateTimeConverter() {
        this.setDefaultDateTimeFormatter(_defaultFormatter);
    }

    @Override
    public synchronized LocalDateTime fromString(String string, ConverterContext context) {
        TemporalAccessor temporalAccessor = this.temporalFromString(string, context);
        if (temporalAccessor != null) {
            return LocalDateTime.from(temporalAccessor);
        }
        return null;
    }

    @Override
    protected DateTimeFormatter getFullDateTimeFormatter() {
        return _fullFormat;
    }

    @Override
    protected DateTimeFormatter getLongDateTimeFormatter() {
        return _longFormat;
    }

    @Override
    protected DateTimeFormatter getMediumDateTimeFormatter() {
        return _mediumFormat;
    }

    @Override
    protected DateTimeFormatter getShortDateTimeFormatter() {
        return _shortFormat;
    }
}

