/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.text.NumberFormat;
import java.util.Locale;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DoubleConverter;

public class PercentConverter
extends DoubleConverter {
    public static final ConverterContext CONTEXT = new ConverterContext("Percent");

    public PercentConverter() {
        this(NumberFormat.getPercentInstance());
    }

    public PercentConverter(Locale locale) {
        this(NumberFormat.getPercentInstance(locale));
    }

    public PercentConverter(NumberFormat format) {
        super(format);
    }

    @Override
    public Double fromString(String string, ConverterContext context) {
        Number number = this.numberFromString(string, context);
        if (number == null) {
            number = Double.parseDouble(string);
        }
        if (string != null && !string.trim().endsWith("%") && number != null) {
            number = number.doubleValue() / 100.0;
        }
        return number != null ? Double.valueOf(number.doubleValue()) : null;
    }
}

