/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;

public abstract class AbstractNumberConverter<T extends Number>
extends DefaultObjectConverter<T> {
    public static final ConverterContext CONTEXT_FIXED_1_DIGIT_FRACTION = new ConverterContext("Fixed1DigitFraction");
    public static final ConverterContext CONTEXT_FIXED_2_DIGIT_FRACTION = new ConverterContext("Fixed2DigitFraction");
    public static final ConverterContext CONTEXT_FIXED_4_DIGIT_FRACTION = new ConverterContext("Fixed4DigitFraction");
    public static final String PROPERTY_NUMBER_FORMAT = "NumberFormat";
    private final Locale _locale;
    private final String _pattern;
    private final NumberFormat _numberFormat;

    public AbstractNumberConverter() {
        this(Locale.getDefault());
    }

    public AbstractNumberConverter(Locale locale) {
        this(locale, null);
    }

    public AbstractNumberConverter(String pattern) {
        this(Locale.getDefault(), pattern);
    }

    public AbstractNumberConverter(Locale locale, String pattern) {
        this(locale, pattern, null);
    }

    public AbstractNumberConverter(NumberFormat numberFormat) {
        this(null, null, numberFormat);
    }

    AbstractNumberConverter(Locale locale, String pattern, NumberFormat numberFormat) {
        this._locale = locale;
        this._pattern = pattern;
        this._numberFormat = numberFormat;
    }

    protected NumberFormat getNumberFormat() {
        Locale locale;
        Locale locale2 = locale = this._locale == null ? Locale.getDefault() : this._locale;
        if (this._numberFormat != null) {
            return this._numberFormat;
        }
        if (this._pattern != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            return new DecimalFormat(this._pattern, symbols);
        }
        return NumberFormat.getNumberInstance(locale);
    }

    public Number numberFromString(String string, ConverterContext context) {
        Object format;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        Object object = format = context != null ? context.getProperties().get((Object)PROPERTY_NUMBER_FORMAT) : null;
        if (format instanceof NumberFormat) {
            try {
                return ((NumberFormat)format).parse(string);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        NumberFormat parser = this.getNumberFormat();
        try {
            return parser.parse(string);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public String toString(T number, ConverterContext context) {
        Object format;
        if (number == null) {
            return "";
        }
        if (Double.isNaN(((Number)number).doubleValue())) {
            return "";
        }
        Object object = format = context != null ? context.getProperties().get((Object)PROPERTY_NUMBER_FORMAT) : null;
        if (format instanceof NumberFormat) {
            try {
                return ((NumberFormat)format).format(number);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        NumberFormat formatter = this.getNumberFormat();
        try {
            return formatter.format(number);
        }
        catch (Exception e) {
            return number.toString();
        }
    }
}

