/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read.converter;

import java.util.function.Consumer;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;

public class EnumConverter
extends PrimitiveConverter {
    private Enum<?>[] dict = null;
    private final Consumer<Object> consumer;
    private final Class<? extends Enum> asEnum;

    public EnumConverter(Consumer<Object> consumer, Class<?> type) {
        this.consumer = consumer;
        this.asEnum = type.asSubclass(Enum.class);
    }

    public void addBinary(Binary value) {
        this.consumer.accept(this.convert(value));
    }

    public boolean hasDictionarySupport() {
        return true;
    }

    public void setDictionary(Dictionary dictionary) {
        int maxId = dictionary.getMaxId();
        this.dict = new Enum[maxId + 1];
        for (int i = 0; i <= maxId; ++i) {
            this.dict[i] = this.convert(dictionary.decodeToBinary(i));
        }
    }

    public void addValueFromDictionary(int dictionaryId) {
        this.consumer.accept(this.dict[dictionaryId]);
    }

    private Enum<?> convert(Binary value) {
        String str = value.toStringUsingUTF8();
        return Enum.valueOf(this.asEnum, str);
    }
}

