/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet;

import com.jerolba.carpet.AnnotatedLevels;
import com.jerolba.carpet.CarpetParquetWriter;
import com.jerolba.carpet.ColumnNamingStrategy;
import com.jerolba.carpet.TimeUnit;
import com.jerolba.carpet.WriteModelFactory;
import com.jerolba.carpet.io.OutputStreamOutputFile;
import com.jerolba.carpet.model.WriteRecordModelType;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.annotations.Beta;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.OutputFile;

public class CarpetWriter<T>
implements Closeable,
Consumer<T> {
    private final ParquetWriter<T> writer;

    public CarpetWriter(OutputFile outputFile, Class<T> recordClass) throws IOException {
        this.writer = new Builder<T>(outputFile, recordClass).buildWriter();
    }

    public CarpetWriter(OutputStream outputStream, Class<T> recordClass) throws IOException {
        OutputStreamOutputFile wrappedStream = new OutputStreamOutputFile(outputStream);
        this.writer = new Builder<T>(wrappedStream, recordClass).buildWriter();
    }

    private CarpetWriter(ParquetWriter<T> writer) {
        this.writer = writer;
    }

    public void write(Collection<T> collection) throws IOException {
        for (T value : collection) {
            this.writer.write(value);
        }
    }

    public void write(T value) throws IOException {
        this.writer.write(value);
    }

    @Override
    public void accept(T value) {
        try {
            this.writer.write(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void write(Stream<T> stream) throws IOException {
        Iterator it = stream.iterator();
        while (it.hasNext()) {
            this.writer.write(it.next());
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public static class Builder<T> {
        private final CarpetParquetWriter.Builder<T> builder;
        private boolean parquetConfProvided = false;
        private boolean hadoopConfProvided = false;

        public Builder(OutputFile path, Class<T> recordClass) {
            this.builder = (CarpetParquetWriter.Builder)((CarpetParquetWriter.Builder)CarpetParquetWriter.builder(path, recordClass).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withCompressionCodec(CompressionCodecName.SNAPPY);
        }

        public Builder(OutputStream outputStream, Class<T> recordClass) {
            this(new OutputStreamOutputFile(outputStream), recordClass);
        }

        public Builder<T> withConf(Configuration conf) {
            this.hadoopConfProvided = true;
            this.builder.withConf(conf);
            return this;
        }

        public Builder<T> withConf(ParquetConfiguration conf) {
            this.parquetConfProvided = true;
            this.builder.withConf(conf);
            return this;
        }

        public Builder<T> withWriteMode(ParquetFileWriter.Mode mode) {
            this.builder.withWriteMode(mode);
            return this;
        }

        public Builder<T> withCompressionCodec(CompressionCodecName codecName) {
            this.builder.withCompressionCodec(codecName);
            return this;
        }

        public Builder<T> withCodecFactory(CompressionCodecFactory codecFactory) {
            this.builder.withCodecFactory(codecFactory);
            return this;
        }

        public Builder<T> withEncryption(FileEncryptionProperties encryptionProperties) {
            this.builder.withEncryption(encryptionProperties);
            return this;
        }

        public Builder<T> withRowGroupSize(long rowGroupSize) {
            this.builder.withRowGroupSize(rowGroupSize);
            return this;
        }

        public Builder<T> withMaxPaddingSize(int maxPaddingSize) {
            this.builder.withMaxPaddingSize(maxPaddingSize);
            return this;
        }

        public Builder<T> enableValidation() {
            this.builder.enableValidation();
            return this;
        }

        public Builder<T> withValidation(boolean enableValidation) {
            this.builder.withValidation(enableValidation);
            return this;
        }

        public Builder<T> withPageSize(int pageSize) {
            this.builder.withPageSize(pageSize);
            return this;
        }

        public Builder<T> withPageRowCountLimit(int rowCount) {
            this.builder.withPageRowCountLimit(rowCount);
            return this;
        }

        public Builder<T> withDictionaryPageSize(int dictionaryPageSize) {
            this.builder.withDictionaryPageSize(dictionaryPageSize);
            return this;
        }

        public Builder<T> enableDictionaryEncoding() {
            this.builder.enableDictionaryEncoding();
            return this;
        }

        public Builder<T> withDictionaryEncoding(boolean enableDictionary) {
            this.builder.withDictionaryEncoding(enableDictionary);
            return this;
        }

        public Builder<T> withByteStreamSplitEncoding(boolean enableByteStreamSplit) {
            this.builder.withByteStreamSplitEncoding(enableByteStreamSplit);
            return this;
        }

        public Builder<T> withDictionaryEncoding(String columnPath, boolean enableDictionary) {
            this.builder.withDictionaryEncoding(columnPath, enableDictionary);
            return this;
        }

        public Builder<T> withWriterVersion(ParquetProperties.WriterVersion version) {
            this.builder.withWriterVersion(version);
            return this;
        }

        public Builder<T> enablePageWriteChecksum() {
            this.builder.enablePageWriteChecksum();
            return this;
        }

        public Builder<T> withPageWriteChecksumEnabled(boolean enablePageWriteChecksum) {
            this.builder.withPageWriteChecksumEnabled(enablePageWriteChecksum);
            return this;
        }

        public Builder<T> withMaxBloomFilterBytes(int maxBloomFilterBytes) {
            this.builder.withMaxBloomFilterBytes(maxBloomFilterBytes);
            return this;
        }

        public Builder<T> withBloomFilterNDV(String columnPath, long ndv) {
            this.builder.withBloomFilterNDV(columnPath, ndv);
            return this;
        }

        public Builder<T> withBloomFilterFPP(String columnPath, double fpp) {
            this.builder.withBloomFilterFPP(columnPath, fpp);
            return this;
        }

        public Builder<T> withAdaptiveBloomFilterEnabled(boolean enabled) {
            this.builder.withAdaptiveBloomFilterEnabled(enabled);
            return this;
        }

        public Builder<T> withBloomFilterCandidateNumber(String columnPath, int number) {
            this.builder.withBloomFilterCandidateNumber(columnPath, number);
            return this;
        }

        public Builder<T> withBloomFilterEnabled(boolean enabled) {
            this.builder.withBloomFilterEnabled(enabled);
            return this;
        }

        public Builder<T> withBloomFilterEnabled(String columnPath, boolean enabled) {
            this.builder.withBloomFilterEnabled(columnPath, enabled);
            return this;
        }

        public Builder<T> withMinRowCountForPageSizeCheck(int min) {
            this.builder.withMinRowCountForPageSizeCheck(min);
            return this;
        }

        public Builder<T> withMaxRowCountForPageSizeCheck(int max) {
            this.builder.withMaxRowCountForPageSizeCheck(max);
            return this;
        }

        public Builder<T> withColumnIndexTruncateLength(int length) {
            this.builder.withColumnIndexTruncateLength(length);
            return this;
        }

        public Builder<T> withStatisticsTruncateLength(int length) {
            this.builder.withStatisticsTruncateLength(length);
            return this;
        }

        public Builder<T> config(String property, String value) {
            this.builder.config(property, value);
            this.parquetConfProvided = true;
            return this;
        }

        public Builder<T> withExtraMetaData(Map<String, String> extraMetaData) {
            this.builder.withExtraMetaData((Map)extraMetaData);
            return this;
        }

        public Builder<T> withExtraMetaData(String key, String value) {
            this.builder.withExtraMetaData(key, value);
            return this;
        }

        public Builder<T> withAllocator(ByteBufferAllocator allocator) {
            this.builder.withAllocator(allocator);
            return this;
        }

        public Builder<T> withLevelStructure(AnnotatedLevels annotatedLevels) {
            this.builder.withLevelStructure(annotatedLevels);
            return this;
        }

        public Builder<T> withColumnNamingStrategy(ColumnNamingStrategy columnNamingStrategy) {
            this.builder.withColumnNamingStrategy(columnNamingStrategy);
            return this;
        }

        public Builder<T> withDefaultTimeUnit(TimeUnit defaultTimeUnit) {
            this.builder.withDefaultTimeUnit(defaultTimeUnit);
            return this;
        }

        public Builder<T> withDefaultDecimal(int precision, int scale) {
            this.builder.withDefaultDecimal(precision, scale);
            return this;
        }

        public Builder<T> withBigDecimalScaleAdjustment(RoundingMode roundingMode) {
            this.builder.withBigDecimalScaleAdjustment(roundingMode);
            return this;
        }

        @Beta
        public Builder<T> withWriteRecordModel(WriteModelFactory<T> writeModelFactory) {
            this.builder.withWriteRecordModel(writeModelFactory);
            return this;
        }

        @Beta
        public Builder<T> withWriteRecordModel(WriteRecordModelType<T> rootWriteRecordModel) {
            this.builder.withWriteRecordModel(rootWriteRecordModel);
            return this;
        }

        public CarpetWriter<T> build() throws IOException {
            return new CarpetWriter<T>(this.buildWriter());
        }

        private ParquetWriter<T> buildWriter() throws IOException {
            if (!this.parquetConfProvided && !this.hadoopConfProvided) {
                this.builder.withConf((ParquetConfiguration)new PlainParquetConfiguration());
            }
            return this.builder.build();
        }
    }
}

