/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet;

import com.jerolba.carpet.FieldMatchingStrategy;
import com.jerolba.carpet.impl.read.CarpetReadConfiguration;
import com.jerolba.carpet.impl.read.CarpetReadSupport;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.InputFile;

public class CarpetParquetReader {
    public static final boolean DEFAULT_FAIL_ON_MISSING_COLUMN = true;
    public static final boolean DEFAULT_FAIL_ON_NULL_FOR_PRIMITIVES = false;
    public static final boolean DEFAULT_FAIL_NARROWING_PRIMITIVE_CONVERSION = false;
    public static final FieldMatchingStrategy DEFAULT_FIELD_MATCHING_STRATEGY = FieldMatchingStrategy.FIELD_NAME;

    private CarpetParquetReader() {
    }

    public static <T> Builder<T> builder(InputFile file, Class<T> readClass) {
        return new Builder<T>(file, readClass);
    }

    public static class Builder<T>
    extends ParquetReader.Builder<T> {
        private final Class<T> recordClass;
        private final InputFile inputFile;
        private boolean failOnMissingColumn = true;
        private boolean failOnNullForPrimitives = false;
        private boolean failNarrowingPrimitiveConversion = false;
        private FieldMatchingStrategy fieldMatchingStrategy = DEFAULT_FIELD_MATCHING_STRATEGY;

        private Builder(InputFile file, Class<T> recordClass) {
            super(file, (ParquetConfiguration)new PlainParquetConfiguration());
            this.inputFile = file;
            this.recordClass = recordClass;
        }

        public InputFile getInputFile() {
            return this.inputFile;
        }

        public Class<T> getRecordClass() {
            return this.recordClass;
        }

        public Builder<T> failOnMissingColumn(boolean failOnMissingColumn) {
            this.failOnMissingColumn = failOnMissingColumn;
            return this;
        }

        public Builder<T> failOnNullForPrimitives(boolean failOnNullForPrimitives) {
            this.failOnNullForPrimitives = failOnNullForPrimitives;
            return this;
        }

        public Builder<T> failNarrowingPrimitiveConversion(boolean failNarrowingPrimitiveConversion) {
            this.failNarrowingPrimitiveConversion = failNarrowingPrimitiveConversion;
            return this;
        }

        public Builder<T> fieldMatchingStrategy(FieldMatchingStrategy fieldMatchingStrategy) {
            this.fieldMatchingStrategy = fieldMatchingStrategy;
            return this;
        }

        protected ReadSupport<T> getReadSupport() {
            CarpetReadConfiguration configuration = new CarpetReadConfiguration(this.failOnMissingColumn, this.failNarrowingPrimitiveConversion, this.failOnNullForPrimitives, this.fieldMatchingStrategy);
            return new CarpetReadSupport<T>(this.recordClass, configuration);
        }
    }
}

