/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.filter.log;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.builder.ResponseBuilder;
import com.jayway.restassured.filter.Filter;
import com.jayway.restassured.filter.FilterContext;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.internal.RestAssuredResponseImpl;
import com.jayway.restassured.internal.print.ResponsePrinter;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.FilterableResponseSpecification;
import java.io.PrintStream;
import org.apache.commons.lang3.Validate;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StatusCodeBasedLoggingFilter
implements Filter {
    private final PrintStream stream;
    private final Matcher<?> matcher;
    private final LogDetail logDetail;
    private final boolean shouldPrettyPrint;

    public StatusCodeBasedLoggingFilter(Matcher<? super Integer> matcher) {
        this(System.out, matcher);
    }

    public StatusCodeBasedLoggingFilter(PrintStream stream, Matcher<? super Integer> matcher) {
        this(LogDetail.ALL, stream, matcher);
    }

    public StatusCodeBasedLoggingFilter(LogDetail logDetail, PrintStream stream, Matcher<? super Integer> matcher) {
        this(logDetail, StatusCodeBasedLoggingFilter.isPrettyPrintingEnabled(), stream, matcher);
    }

    public StatusCodeBasedLoggingFilter(LogDetail logDetail, boolean prettyPrint, PrintStream stream, Matcher<? super Integer> matcher) {
        Validate.notNull((Object)((Object)logDetail), (String)"Log details cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)stream, (String)"Print stream cannot be null", (Object[])new Object[0]);
        Validate.notNull(matcher, (String)"Matcher cannot be null", (Object[])new Object[0]);
        if (logDetail == LogDetail.PARAMS) {
            throw new IllegalArgumentException(String.format("%s is not a valid %s for a response.", new Object[]{LogDetail.PARAMS, LogDetail.class.getSimpleName()}));
        }
        this.shouldPrettyPrint = prettyPrint;
        this.logDetail = logDetail;
        this.stream = stream;
        this.matcher = matcher;
    }

    @Override
    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        Response response = ctx.next(requestSpec, responseSpec);
        int statusCode = response.statusCode();
        if (this.matcher.matches((Object)statusCode)) {
            String responseAsString = ResponsePrinter.print(response, response, this.stream, this.logDetail, this.shouldPrettyPrint);
            response = this.cloneResponseIfNeeded(response, responseAsString);
        }
        return response;
    }

    private Response cloneResponseIfNeeded(Response response, String responseAsString) {
        if (responseAsString != null && response instanceof RestAssuredResponseImpl && !((RestAssuredResponseImpl)response).getHasExpectations()) {
            Response build = new ResponseBuilder().clone(response).setBody(responseAsString).build();
            ((RestAssuredResponseImpl)build).setHasExpectations(true);
            return build;
        }
        return response;
    }

    private static boolean isPrettyPrintingEnabled() {
        return RestAssured.config == null ? true : RestAssured.config.getLogConfig().isPrettyPrintingEnabled();
    }
}

