/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.jayway.maven.plugins.android.AbstractIntegrationtestMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractInstrumentationMojo
extends AbstractIntegrationtestMojo {
    private String instrumentationPackage;
    private String instrumentationRunner;

    protected void instrument() throws MojoExecutionException, MojoFailureException {
        if (this.instrumentationPackage == null) {
            this.instrumentationPackage = this.extractPackageNameFromAndroidManifest(this.androidManifestFile);
        }
        if (this.instrumentationRunner == null) {
            this.instrumentationRunner = this.extractInstrumentationRunnerFromAndroidManifest(this.androidManifestFile);
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        this.addDeviceParameter(commands);
        commands.add("shell");
        commands.add("am");
        commands.add("instrument");
        commands.add("-w");
        String testPackages = this.buildTestPackagesString();
        String testClasses = this.buildTestClassesString();
        boolean tcExists = StringUtils.isNotBlank((String)testClasses);
        boolean tpExists = StringUtils.isNotBlank((String)testPackages);
        if (tcExists && tpExists) {
            throw new MojoFailureException("testPackages and testClasses are mutual exclusive. They cannot be specified at the same time. Please specify either testPackages or testClasses! For details, see http://developer.android.com/guide/developing/testing/testing_otheride.html");
        }
        if (tpExists) {
            commands.add("-e");
            commands.add("package");
            commands.add(testPackages);
            this.getLog().info((CharSequence)("Running tests for specified test packages: " + testPackages));
        }
        if (tcExists) {
            commands.add("-e");
            commands.add("class");
            commands.add(testClasses);
            this.getLog().info((CharSequence)("Running tests for specified test classes/methods: " + testClasses));
        }
        commands.add(this.instrumentationPackage + "/" + this.instrumentationRunner);
        this.getLog().info((CharSequence)(this.getAndroidSdk().getAdbPath() + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getAdbPath(), commands, this.project.getBasedir(), true);
            String standardOut = executor.getStandardOut();
            String standardError = executor.getStandardError();
            this.getLog().debug((CharSequence)standardOut);
            this.getLog().debug((CharSequence)standardError);
            if (standardOut == null || !standardOut.matches(".*?OK \\([0-9]+ tests?\\)\\s*")) {
                throw new MojoFailureException("Tests failed on device.");
            }
        }
        catch (ExecutionException e) {
            this.getLog().error((CharSequence)executor.getStandardOut());
            this.getLog().error((CharSequence)executor.getStandardError());
            throw new MojoFailureException("Tests failed on device.");
        }
    }
}

