/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase09package;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ApkBuilder {
    private static Class apkBuilderClass;
    private static Log log;
    private Object builder;
    private static Constructor apkBuilderConstructor;
    private static Method addSourceFolderMethod;
    private static Method addResourcesFromJarMethod;
    private static Method addNativeLibrariesMethod;
    private static Method setDebugMethod;
    private static Method sealApkMethod;
    private static Method getDebugKeyStoreMethod;

    public static void initialize(Log log, File sdkLibs) throws MojoExecutionException {
        if (apkBuilderClass != null) {
            return;
        }
        ApkBuilder.log = log;
        try {
            URLClassLoader child = new URLClassLoader(new URL[]{sdkLibs.toURI().toURL()}, ApkBuilder.class.getClassLoader());
            apkBuilderClass = child.loadClass("com.android.sdklib.build.ApkBuilder");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot create a correct URL from file " + sdkLibs.getAbsolutePath());
        }
        catch (ClassNotFoundException e) {
            log.error((Throwable)e);
            throw new MojoExecutionException("Cannot load 'com.android.sdklib.build.ApkBuilder'");
        }
        log.debug((CharSequence)("ApkBuilder loaded " + apkBuilderClass));
        try {
            apkBuilderConstructor = apkBuilderClass.getConstructor(File.class, File.class, File.class, String.class, PrintStream.class);
            setDebugMethod = apkBuilderClass.getMethod("setDebugMode", Boolean.TYPE);
            addResourcesFromJarMethod = apkBuilderClass.getMethod("addResourcesFromJar", File.class);
            addNativeLibrariesMethod = apkBuilderClass.getMethod("addNativeLibraries", File.class, String.class);
            addSourceFolderMethod = apkBuilderClass.getMethod("addSourceFolder", File.class);
            sealApkMethod = apkBuilderClass.getMethod("sealApk", new Class[0]);
            getDebugKeyStoreMethod = apkBuilderClass.getMethod("getDebugKeystore", new Class[0]);
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot find required method", (Throwable)e);
            throw new MojoExecutionException("Cannot find the required method", e);
        }
    }

    public ApkBuilder(File apkFile, File resFile, File dexFile, boolean signed, PrintStream verboseStream) throws MojoExecutionException {
        if (apkBuilderClass == null) {
            throw new MojoExecutionException("The APKBuilder class was not initialized");
        }
        try {
            Object debugKeyStore = getDebugKeyStoreMethod.invoke(null, new Object[0]);
            this.builder = apkBuilderConstructor.newInstance(apkFile, resFile, dexFile, signed ? debugKeyStore : null, verboseStream);
        }
        catch (InvocationTargetException e) {
            log.error((CharSequence)"Cannot create the APKBuilder object", e.getCause());
            throw new MojoExecutionException("Cannot create the APKBuilder object", e.getCause());
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot create the APKBuilder object", (Throwable)e);
            throw new MojoExecutionException("Cannot create the APKBuilder object", e);
        }
    }

    public void setDebugMode(boolean debug) throws MojoExecutionException {
        try {
            setDebugMethod.invoke(this.builder, debug);
        }
        catch (InvocationTargetException e) {
            log.error((CharSequence)"Cannot set the debug mode", e.getCause());
            throw new MojoExecutionException("Cannot create the APKBuilder object", e.getCause());
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot set the debug mode", (Throwable)e);
            throw new MojoExecutionException("Cannot create the APKBuilder object", e);
        }
    }

    public void addSourceFolder(File sourceFolder) throws MojoExecutionException {
        try {
            addSourceFolderMethod.invoke(this.builder, sourceFolder);
        }
        catch (InvocationTargetException e) {
            log.error((CharSequence)"Cannot add source folder", e.getCause());
            throw new MojoExecutionException("Cannot add source folder", e.getCause());
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot add source folder", (Throwable)e);
            throw new MojoExecutionException("Cannot add source folder", e);
        }
    }

    public void addResourcesFromJar(File jarFile) throws MojoExecutionException {
        try {
            addResourcesFromJarMethod.invoke(this.builder, jarFile);
        }
        catch (InvocationTargetException e) {
            log.error((CharSequence)"Cannot add resources from jar", e.getCause());
            throw new MojoExecutionException("Cannot add resources from jar", e.getCause());
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot add source folder", (Throwable)e);
            throw new MojoExecutionException("Cannot add resources from jar", e);
        }
    }

    public void addNativeLibraries(File nativeFolder, String abiFilter) throws MojoExecutionException {
        try {
            addNativeLibrariesMethod.invoke(this.builder, nativeFolder, abiFilter);
        }
        catch (InvocationTargetException e) {
            log.error((CharSequence)"Cannot add native libraries", e.getCause());
            throw new MojoExecutionException("Cannot add native libraries", e.getCause());
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot add native libraries", (Throwable)e);
            throw new MojoExecutionException("Cannot add native libraries", e);
        }
    }

    public void sealApk() throws MojoExecutionException {
        try {
            sealApkMethod.invoke(this.builder, new Object[0]);
        }
        catch (InvocationTargetException e) {
            log.error((CharSequence)"Cannot seal the APK", e.getCause());
            throw new MojoExecutionException("Cannot seal the APK", e.getCause());
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot seal the APK", (Throwable)e);
            throw new MojoExecutionException("Cannot seal the APK", e);
        }
    }
}

