/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.DeviceHelper;
import com.jayway.maven.plugins.android.config.ConfigHandler;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.MonkeyRunner;
import com.jayway.maven.plugins.android.configuration.Program;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.os.Os;
import org.codehaus.plexus.util.cli.shell.BourneShell;
import org.codehaus.plexus.util.cli.shell.Shell;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MonkeyRunnerMojo
extends AbstractAndroidMojo {
    private boolean mavenTestSkip;
    private boolean mavenSkipTests;
    private boolean mavenTestFailureIgnore;
    private boolean mavenIgnoreTestFailure;
    @ConfigPojo
    private MonkeyRunner monkeyrunner;
    private Boolean monkeyRunnerSkip;
    @PullParameter(defaultValue="true")
    private Boolean parsedSkip;
    private String[] monkeyPlugins;
    @PullParameter(defaultValueGetterMethod="getPlugins")
    private String[] parsedPlugins;
    @PullParameter(required=false, defaultValueGetterMethod="getPrograms")
    private List<Program> parsedPrograms;
    private Boolean monkeyCreateReport;
    @PullParameter(defaultValue="false")
    private Boolean parsedCreateReport;
    private Boolean monkeyInjectDeviceSerialNumberIntoScript;
    @PullParameter(defaultValue="false")
    private Boolean parsedInjectDeviceSerialNumberIntoScript;
    private long elapsedTime;
    private ITestRunListener[] mTestListeners;
    private Map<String, String> runMetrics;
    private String mRunName;
    private int eventCount;
    private TestIdentifier mCurrentTestIndentifier;
    private MonkeyRunnerErrorListener errorListener;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ConfigHandler configHandler = new ConfigHandler((Object)this);
        configHandler.parseConfiguration();
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
                AndroidTestRunListener testRunListener = new AndroidTestRunListener(MonkeyRunnerMojo.this.project, device);
                if (MonkeyRunnerMojo.this.isEnableIntegrationTest()) {
                    MonkeyRunnerMojo.this.run(device, testRunListener);
                }
            }
        });
    }

    protected boolean isEnableIntegrationTest() {
        return this.parsedSkip == false && !this.mavenTestSkip && !this.mavenSkipTests;
    }

    protected boolean isIgnoreTestFailures() {
        return this.mavenIgnoreTestFailure || this.mavenTestFailureIgnore;
    }

    protected void run(IDevice device, ITestRunListener ... iTestRunListeners) throws MojoExecutionException, MojoFailureException {
        this.mTestListeners = iTestRunListeners;
        this.getLog().debug((CharSequence)"Parsed values for Android Monkey Runner invocation: ");
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        if (!Os.isFamily((String)"windows")) {
            executor.setCustomShell((Shell)new CustomBourneShell());
        }
        executor.setLogger(this.getLog());
        String command = this.getAndroidSdk().getMonkeyRunnerPath();
        ArrayList<String> pluginParameters = new ArrayList<String>();
        if (this.parsedPlugins != null && this.parsedPlugins.length != 0) {
            for (String plugin : this.parsedPlugins) {
                String pluginFilePath = new File(this.project.getBasedir(), plugin).getAbsolutePath();
                pluginParameters.add("-plugin " + pluginFilePath);
            }
        }
        if (this.parsedPrograms != null && !this.parsedPrograms.isEmpty()) {
            this.handleTestRunStarted();
            this.errorListener = new MonkeyRunnerErrorListener();
            executor.setErrorListener(this.errorListener);
            for (Program program : this.parsedPrograms) {
                block11: {
                    ArrayList<String> parameters = new ArrayList<String>(pluginParameters);
                    String programFileName = new File(this.project.getBasedir(), program.getFilename()).getAbsolutePath();
                    parameters.add(programFileName);
                    String testName = programFileName;
                    if (testName.contains("/")) {
                        testName.substring(testName.indexOf(47) + 1);
                    }
                    this.mCurrentTestIndentifier = new TestIdentifier("MonkeyTest ", testName);
                    String programOptions = program.getOptions();
                    if (this.parsedInjectDeviceSerialNumberIntoScript != null && this.parsedInjectDeviceSerialNumberIntoScript.booleanValue()) {
                        parameters.add(device.getSerialNumber());
                    }
                    if (programOptions != null && !StringUtils.isEmpty((String)programOptions)) {
                        parameters.add(programOptions);
                    }
                    try {
                        this.getLog().info((CharSequence)("Running command: " + command));
                        this.getLog().info((CharSequence)("with parameters: " + parameters));
                        this.handleTestStarted();
                        executor.executeCommand(command, parameters, true);
                        this.handleTestEnded();
                    }
                    catch (ExecutionException e) {
                        this.getLog().info((CharSequence)"Monkey runner produced errors");
                        this.handleTestRunFailed(e.getMessage());
                        if (this.isIgnoreTestFailures()) break block11;
                        this.getLog().info((CharSequence)"Project is configured to fail on error.");
                        this.getLog().info((CharSequence)"Inspect monkey runner reports or re-run with -X to see monkey runner errors in log");
                        this.getLog().info((CharSequence)"Failing build as configured. Ignore following error message.");
                        if (this.errorListener.hasError) {
                            this.getLog().info((CharSequence)"Stack trace is:");
                            this.getLog().info((CharSequence)this.errorListener.getStackTrace());
                        }
                        throw new MojoExecutionException("", (Exception)e);
                    }
                }
                if (!this.errorListener.hasError()) continue;
                this.handleCrash();
            }
            this.handleTestRunEnded();
        }
        this.getLog().info((CharSequence)"Monkey runner test runs completed successfully.");
    }

    private void handleTestRunStarted() {
        this.runMetrics = new HashMap<String, String>();
        this.elapsedTime = System.currentTimeMillis();
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testRunStarted(this.mRunName, this.eventCount);
        }
    }

    private void handleTestRunFailed(String error) {
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testRunFailed(error);
        }
    }

    private void handleTestRunEnded() {
        this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testRunEnded(this.elapsedTime, this.runMetrics);
        }
    }

    private void handleTestStarted() {
        System.out.println("TEST START " + this.mTestListeners.length);
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testStarted(this.mCurrentTestIndentifier);
        }
    }

    private void handleTestEnded() {
        if (this.mCurrentTestIndentifier != null) {
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testEnded(this.mCurrentTestIndentifier, new HashMap());
            }
            this.mCurrentTestIndentifier = null;
        }
    }

    private void handleCrash() {
        String trace = this.errorListener.getStackTrace();
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testFailed(ITestRunListener.TestFailure.ERROR, this.mCurrentTestIndentifier, trace);
        }
        this.mCurrentTestIndentifier = null;
    }

    public String[] getPlugins() {
        return this.parsedPlugins;
    }

    public List<Program> getPrograms() {
        return this.parsedPrograms;
    }

    private static final class CustomBourneShell
    extends BourneShell {
        private CustomBourneShell() {
        }

        public List<String> getShellArgsList() {
            ArrayList<String> shellArgs = new ArrayList<String>();
            List existingShellArgs = super.getShellArgsList();
            if (existingShellArgs != null && !existingShellArgs.isEmpty()) {
                shellArgs.addAll(existingShellArgs);
            }
            return shellArgs;
        }

        public String[] getShellArgs() {
            String[] shellArgs = super.getShellArgs();
            if (shellArgs == null) {
                shellArgs = new String[]{};
            }
            return shellArgs;
        }
    }

    public class AndroidTestRunListener
    implements ITestRunListener {
        private static final String SCREENSHOT_SUFFIX = "_screenshot.png";
        private static final String INDENT = "  ";
        private static final String TAG_TESTSUITES = "testsuites";
        private static final String TAG_TESTSUITE = "testsuite";
        private static final String ATTR_TESTSUITE_ERRORS = "errors";
        private static final String ATTR_TESTSUITE_FAILURES = "failures";
        private static final String ATTR_TESTSUITE_HOSTNAME = "hostname";
        private static final String ATTR_TESTSUITE_NAME = "name";
        private static final String ATTR_TESTSUITE_TESTS = "tests";
        private static final String ATTR_TESTSUITE_TIME = "time";
        private static final String ATTR_TESTSUITE_TIMESTAMP = "timestamp";
        private static final String TAG_PROPERTIES = "properties";
        private static final String TAG_PROPERTY = "property";
        private static final String ATTR_PROPERTY_NAME = "name";
        private static final String ATTR_PROPERTY_VALUE = "value";
        private static final String TAG_TESTCASE = "testcase";
        private static final String ATTR_TESTCASE_NAME = "name";
        private static final String ATTR_TESTCASE_CLASSNAME = "classname";
        private static final String ATTR_TESTCASE_TIME = "time";
        private static final String TAG_ERROR = "error";
        private static final String TAG_FAILURE = "failure";
        private static final String ATTR_MESSAGE = "message";
        private static final String ATTR_TYPE = "type";
        private final NumberFormat timeFormatter = new DecimalFormat("#0.0000");
        private int testCount = 0;
        private int testRunCount = 0;
        private int testFailureCount = 0;
        private int testErrorCount = 0;
        private String testRunFailureCause = null;
        private final MavenProject project;
        private final IDevice device;
        private final String deviceLogLinePrefix;
        private Document junitReport;
        private Node testSuiteNode;
        private Node currentTestCaseNode;
        private long currentTestCaseStartTime;
        private boolean threwException = false;
        private final StringBuilder exceptionMessages = new StringBuilder();

        public AndroidTestRunListener(MavenProject project, IDevice device) {
            this.project = project;
            this.device = device;
            this.deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
        }

        public void testRunStarted(String runName, int tCount) {
            this.testCount = tCount;
            MonkeyRunnerMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run started: " + runName + ", " + this.testCount + " tests:"));
            if (MonkeyRunnerMojo.this.parsedCreateReport.booleanValue()) {
                try {
                    Attr propValueAttr;
                    Attr propNameAttr;
                    NamedNodeMap propertyAttributes;
                    Element propertyNode;
                    DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                    DocumentBuilder parser = null;
                    parser = fact.newDocumentBuilder();
                    this.junitReport = parser.newDocument();
                    Element testSuitesNode = this.junitReport.createElement(TAG_TESTSUITES);
                    this.junitReport.appendChild(testSuitesNode);
                    this.testSuiteNode = this.junitReport.createElement(TAG_TESTSUITE);
                    NamedNodeMap testSuiteAttributes = this.testSuiteNode.getAttributes();
                    Attr nameAttr = this.junitReport.createAttribute("name");
                    nameAttr.setValue(runName);
                    testSuiteAttributes.setNamedItem(nameAttr);
                    Attr hostnameAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_HOSTNAME);
                    hostnameAttr.setValue(DeviceHelper.getDescriptiveName(this.device));
                    testSuiteAttributes.setNamedItem(hostnameAttr);
                    Element propertiesNode = this.junitReport.createElement(TAG_PROPERTIES);
                    for (Map.Entry<Object, Object> systemProperty : System.getProperties().entrySet()) {
                        propertyNode = this.junitReport.createElement(TAG_PROPERTY);
                        propertyAttributes = propertyNode.getAttributes();
                        propNameAttr = this.junitReport.createAttribute("name");
                        propNameAttr.setValue(systemProperty.getKey().toString());
                        propertyAttributes.setNamedItem(propNameAttr);
                        propValueAttr = this.junitReport.createAttribute(ATTR_PROPERTY_VALUE);
                        propValueAttr.setValue(systemProperty.getValue().toString());
                        propertyAttributes.setNamedItem(propValueAttr);
                        propertiesNode.appendChild(propertyNode);
                    }
                    Map deviceProperties = this.device.getProperties();
                    for (Map.Entry deviceProperty : deviceProperties.entrySet()) {
                        propertyNode = this.junitReport.createElement(TAG_PROPERTY);
                        propertyAttributes = propertyNode.getAttributes();
                        propNameAttr = this.junitReport.createAttribute("name");
                        propNameAttr.setValue((String)deviceProperty.getKey());
                        propertyAttributes.setNamedItem(propNameAttr);
                        propValueAttr = this.junitReport.createAttribute(ATTR_PROPERTY_VALUE);
                        propValueAttr.setValue((String)deviceProperty.getValue());
                        propertyAttributes.setNamedItem(propValueAttr);
                        propertiesNode.appendChild(propertyNode);
                    }
                    this.testSuiteNode.appendChild(propertiesNode);
                    testSuitesNode.appendChild(this.testSuiteNode);
                }
                catch (ParserConfigurationException e) {
                    this.threwException = true;
                    this.exceptionMessages.append("Failed to create document");
                    this.exceptionMessages.append(e.getMessage());
                }
            }
        }

        public void testStarted(TestIdentifier testIdentifier) {
            ++this.testRunCount;
            MonkeyRunnerMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + String.format("%1$s%1$sStart [%2$d/%3$d]: %4$s", INDENT, this.testRunCount, this.testCount, testIdentifier.toString())));
            if (MonkeyRunnerMojo.this.parsedCreateReport.booleanValue()) {
                this.currentTestCaseStartTime = new Date().getTime();
                this.currentTestCaseNode = this.junitReport.createElement(TAG_TESTCASE);
                NamedNodeMap testCaseAttributes = this.currentTestCaseNode.getAttributes();
                Attr classAttr = this.junitReport.createAttribute(ATTR_TESTCASE_CLASSNAME);
                classAttr.setValue(testIdentifier.getClassName());
                testCaseAttributes.setNamedItem(classAttr);
                Attr methodAttr = this.junitReport.createAttribute("name");
                methodAttr.setValue(testIdentifier.getTestName());
                testCaseAttributes.setNamedItem(methodAttr);
            }
        }

        public void testFailed(ITestRunListener.TestFailure status, TestIdentifier testIdentifier, String trace) {
            if (status == ITestRunListener.TestFailure.ERROR) {
                ++this.testErrorCount;
            } else {
                ++this.testFailureCount;
            }
            MonkeyRunnerMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + status.name() + ":" + testIdentifier.toString()));
            MonkeyRunnerMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + trace));
            if (MonkeyRunnerMojo.this.parsedCreateReport.booleanValue()) {
                NamedNodeMap errorfailureAttributes;
                Element errorFailureNode;
                if (status == ITestRunListener.TestFailure.ERROR) {
                    errorFailureNode = this.junitReport.createElement(TAG_ERROR);
                    errorfailureAttributes = errorFailureNode.getAttributes();
                } else {
                    errorFailureNode = this.junitReport.createElement(TAG_FAILURE);
                    errorfailureAttributes = errorFailureNode.getAttributes();
                }
                errorFailureNode.setTextContent(trace);
                Attr msgAttr = this.junitReport.createAttribute(ATTR_MESSAGE);
                msgAttr.setValue(this.parseForMessage(trace));
                errorfailureAttributes.setNamedItem(msgAttr);
                Attr typeAttr = this.junitReport.createAttribute(ATTR_TYPE);
                typeAttr.setValue(this.parseForException(trace));
                errorfailureAttributes.setNamedItem(typeAttr);
                this.currentTestCaseNode.appendChild(errorFailureNode);
            }
        }

        private void executeOnAdbShell(String command) {
            try {
                this.device.executeShellCommand(command, new IShellOutputReceiver(){

                    public boolean isCancelled() {
                        return false;
                    }

                    public void flush() {
                    }

                    public void addOutput(byte[] data, int offset, int length) {
                    }
                });
            }
            catch (TimeoutException e) {
                MonkeyRunnerMojo.this.getLog().error((Throwable)e);
            }
            catch (AdbCommandRejectedException e) {
                MonkeyRunnerMojo.this.getLog().error((Throwable)e);
            }
            catch (ShellCommandUnresponsiveException e) {
                MonkeyRunnerMojo.this.getLog().error((Throwable)e);
            }
            catch (IOException e) {
                MonkeyRunnerMojo.this.getLog().error((Throwable)e);
            }
        }

        public void testEnded(TestIdentifier testIdentifier, Map<String, String> testMetrics) {
            MonkeyRunnerMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + String.format("%1$s%1$sEnd [%2$d/%3$d]: %4$s", INDENT, this.testRunCount, this.testCount, testIdentifier.toString())));
            this.logMetrics(testMetrics);
            if (MonkeyRunnerMojo.this.parsedCreateReport.booleanValue()) {
                this.testSuiteNode.appendChild(this.currentTestCaseNode);
                NamedNodeMap testCaseAttributes = this.currentTestCaseNode.getAttributes();
                Attr timeAttr = this.junitReport.createAttribute("time");
                long now = new Date().getTime();
                double seconds = (double)(now - this.currentTestCaseStartTime) / 1000.0;
                timeAttr.setValue(this.timeFormatter.format(seconds));
                testCaseAttributes.setNamedItem(timeAttr);
            }
        }

        public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
            MonkeyRunnerMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run ended: " + elapsedTime + " ms"));
            if (this.hasFailuresOrErrors()) {
                MonkeyRunnerMojo.this.getLog().error((CharSequence)(this.deviceLogLinePrefix + INDENT + "FAILURES!!!"));
            }
            MonkeyRunnerMojo.this.getLog().info((CharSequence)("  Tests run: " + this.testRunCount + (this.testRunCount < this.testCount ? " (of " + this.testCount + ")" : "") + ",  Failures: " + this.testFailureCount + ",  Errors: " + this.testErrorCount));
            if (MonkeyRunnerMojo.this.parsedCreateReport.booleanValue()) {
                NamedNodeMap testSuiteAttributes = this.testSuiteNode.getAttributes();
                Attr testCountAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_TESTS);
                testCountAttr.setValue(Integer.toString(this.testCount));
                testSuiteAttributes.setNamedItem(testCountAttr);
                Attr testFailuresAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_FAILURES);
                testFailuresAttr.setValue(Integer.toString(this.testFailureCount));
                testSuiteAttributes.setNamedItem(testFailuresAttr);
                Attr testErrorsAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_ERRORS);
                testErrorsAttr.setValue(Integer.toString(this.testErrorCount));
                testSuiteAttributes.setNamedItem(testErrorsAttr);
                Attr timeAttr = this.junitReport.createAttribute("time");
                timeAttr.setValue(this.timeFormatter.format((double)elapsedTime / 1000.0));
                testSuiteAttributes.setNamedItem(timeAttr);
                Attr timeStampAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_TIMESTAMP);
                timeStampAttr.setValue(new Date().toString());
                testSuiteAttributes.setNamedItem(timeStampAttr);
            }
            this.logMetrics(runMetrics);
            if (MonkeyRunnerMojo.this.parsedCreateReport.booleanValue()) {
                this.writeJunitReportToFile();
            }
        }

        public void testRunFailed(String errorMessage) {
            this.testRunFailureCause = errorMessage;
            MonkeyRunnerMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run failed: " + errorMessage));
        }

        public void testRunStopped(long elapsedTime) {
            MonkeyRunnerMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run stopped:" + elapsedTime));
        }

        private String parseForMessage(String trace) {
            if (StringUtils.isNotBlank((String)trace)) {
                boolean hasMessage;
                String newline = "\r\n";
                int messageEnd = trace.indexOf(newline);
                boolean bl = hasMessage = !trace.startsWith("junit.") && messageEnd > 0;
                if (hasMessage) {
                    int messageStart = trace.indexOf(":") + 2;
                    if (messageStart > messageEnd && messageStart > (messageEnd = trace.indexOf(newline + "at"))) {
                        messageStart = 0;
                    }
                    return trace.substring(messageStart, messageEnd);
                }
                return "";
            }
            return "";
        }

        private String parseForException(String trace) {
            if (StringUtils.isNotBlank((String)trace)) {
                return trace.substring(0, trace.indexOf(":"));
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void writeJunitReportToFile() {
            block9: {
                TransformerFactory xfactory = TransformerFactory.newInstance();
                Transformer xformer = null;
                try {
                    xformer = xfactory.newTransformer();
                }
                catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                }
                DOMSource source = new DOMSource(this.junitReport);
                FileWriter writer = null;
                try {
                    String directory = this.project.getBuild().getDirectory() + "/surefire-reports";
                    FileUtils.forceMkdir((File)new File(directory));
                    String fileName = directory + "/TEST-" + DeviceHelper.getDescriptiveName(this.device) + ".xml";
                    File reportFile = new File(fileName);
                    writer = new FileWriter(reportFile);
                    StreamResult result = new StreamResult(writer);
                    xformer.transform(source, result);
                    MonkeyRunnerMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + "Report file written to " + reportFile.getAbsolutePath()));
                    IOUtils.closeQuietly((Writer)writer);
                }
                catch (IOException e) {
                    this.threwException = true;
                    this.exceptionMessages.append("Failed to write test report file");
                    this.exceptionMessages.append(e.getMessage());
                }
                catch (TransformerException e2) {
                    this.threwException = true;
                    this.exceptionMessages.append("Failed to transform document to write to test report file");
                    this.exceptionMessages.append(e2.getMessage());
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeQuietly(writer);
                }
            }
        }

        private void logMetrics(Map<String, String> metrics) {
            for (Map.Entry<String, String> entry : metrics.entrySet()) {
                MonkeyRunnerMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + entry.getKey() + ": " + entry.getValue()));
            }
        }

        public boolean hasFailuresOrErrors() {
            return this.testErrorCount > 0 || this.testFailureCount > 0;
        }

        public boolean testRunFailed() {
            return this.testRunFailureCause != null;
        }

        public String getTestRunFailureCause() {
            return this.testRunFailureCause;
        }

        public boolean threwException() {
            return this.threwException;
        }

        public String getExceptionMessages() {
            return this.exceptionMessages.toString();
        }
    }

    private final class MonkeyRunnerErrorListener
    implements CommandExecutor.ErrorListener {
        private StringBuilder stackTraceBuilder = new StringBuilder();
        private boolean hasError = false;

        private MonkeyRunnerErrorListener() {
        }

        @Override
        public boolean isError(String error) {
            Pattern pattern;
            Matcher matcher;
            if (MonkeyRunnerMojo.this.isIgnoreTestFailures()) {
                return false;
            }
            if (this.hasError) {
                this.stackTraceBuilder.append(error).append('\n');
            }
            if ((matcher = (pattern = Pattern.compile(".*error.*|.*exception.*", 2)).matcher(error)).matches()) {
                this.hasError = true;
                this.stackTraceBuilder.append(error).append('\n');
                return true;
            }
            return false;
        }

        public String getStackTrace() {
            if (this.hasError) {
                return this.stackTraceBuilder.toString();
            }
            return null;
        }

        public boolean hasError() {
            return this.hasError;
        }
    }
}

