/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBLoader;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import java.util.List;
import org.openjena.riot.Lang;
import tdb.cmdline.CmdTDB;
import tdb.cmdline.ModModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class tdbloader
extends CmdTDB {
    private static final ModModel modRDFS = new ModModel("rdfs", new String[0]);
    private boolean showProgress = true;
    private boolean doIncremental = false;

    public static void main(String ... argv) {
        TDB.setOptimizerWarningFlag(false);
        new tdbloader(argv).mainRun();
    }

    protected tdbloader(String[] argv) {
        super(argv);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
    }

    protected String getSummary() {
        return this.getCommandName() + " [--desc DATASET | -loc DIR] FILE ...";
    }

    protected void exec() {
        Lang lang;
        List urls;
        if (this.isVerbose()) {
            System.out.println("Java maximum memory: " + Runtime.getRuntime().maxMemory());
            System.out.println(ARQ.getContext());
        }
        if (this.isVerbose()) {
            this.showProgress = true;
        }
        if (this.isQuiet()) {
            this.showProgress = false;
        }
        if ((urls = this.getPositional()).size() == 0) {
            urls.add("-");
        }
        if (modRDFS.getModel() != null) {
            // empty if block
        }
        boolean allTriples = true;
        for (String url : urls) {
            lang = Lang.guess((String)url, (Lang)Lang.NQUADS);
            if (lang == null || !lang.isQuads()) continue;
            allTriples = false;
            break;
        }
        if (allTriples && this.graphName == null) {
            this.loadDefaultGraph(urls);
            return;
        }
        if (this.graphName == null) {
            this.loadQuads(urls);
            return;
        }
        if (!allTriples) {
            for (String url : urls) {
                lang = Lang.guess((String)url, (Lang)Lang.NQUADS);
                if (lang == null) {
                    this.cmdError("File suffix not recognized: " + url);
                }
                if (lang == null || lang.isTriples()) continue;
                this.cmdError("Can only load triples into a named model: " + url);
            }
            this.cmdError("Internal error: deteched quad input but can't find it again");
            return;
        }
        this.loadNamedGraph(urls);
    }

    void loadDefaultGraph(List<String> urls) {
        GraphTDB graph = this.getGraph();
        TDBLoader.load(graph, urls, this.showProgress);
    }

    void loadNamedGraph(List<String> urls) {
        GraphTDB graph = this.getGraph();
        TDBLoader.load(graph, urls, this.showProgress);
    }

    void loadQuads(List<String> urls) {
        TDBLoader.load(this.getDatasetGraph(), urls, this.showProgress);
    }
}

