/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.core.DatasetPrefixStorage;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderLib;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.file.MetaFile;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexRecord;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.mgt.TDBSystemInfoMBean;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTableCache;
import com.hp.hpl.jena.tdb.nodetable.NodeTableFactory;
import com.hp.hpl.jena.tdb.nodetable.NodeTableInline;
import com.hp.hpl.jena.tdb.nodetable.NodeTableNative;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.ConcurrencyPolicy;
import com.hp.hpl.jena.tdb.sys.ConcurrencyPolicyMRSW;
import com.hp.hpl.jena.tdb.sys.Names;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.io.IOException;
import java.util.Properties;
import org.openjena.atlas.lib.ColumnMap;
import org.openjena.atlas.lib.FileOps;
import org.openjena.atlas.lib.PropertyUtils;
import org.openjena.atlas.lib.StrUtils;
import org.slf4j.Logger;

public class SetupTDB {
    static final Logger log = TDB.logInfo;
    public static final String NodeTableType = "dat";
    public static final String NodeTableLayout = "1";
    public static final Properties globalConfig = new Properties();
    public static final TDBSystemInfoMBean systemInfo;
    private static boolean warnAboutOptimizer;

    public static DatasetGraphTDB buildDataset(Location location) {
        String base;
        String key;
        boolean unionDefaultGraph;
        String propertiesFile = "tdb.properties";
        MetaFile metafile = SetupTDB.locationMetadata(location);
        Properties config = new Properties(globalConfig);
        boolean localProperties = false;
        if (location.exists(propertiesFile)) {
            localProperties = true;
            try {
                PropertyUtils.loadFromFile((Properties)config, (String)propertiesFile);
            }
            catch (IOException ex) {
                throw new TDBException(ex);
            }
        }
        if (!metafile.propertyEquals("tdb.layout", "v1")) {
            SetupTDB.error(log, "Excepted 'v1': Wrong layout: " + metafile.getProperty("tdb.layout"));
        }
        if (!metafile.propertyEquals("tdb.type", "standalone")) {
            SetupTDB.error(log, "Not marked as a standalone type: " + metafile.getProperty("tdb.type"));
        }
        metafile.checkOrSetMetadata("tdb.nodeid.size", Integer.toString(8));
        metafile.checkOrSetMetadata("tdb.node.hashsize", Integer.toString(16));
        metafile.checkOrSetMetadata("tdb.record.triple", Integer.toString(24));
        metafile.checkOrSetMetadata("tdb.record.quad", Integer.toString(32));
        String indexNode2Id = metafile.getProperty("tdb.nodetable.mapping.node2id");
        String indexId2Node = metafile.getProperty("tdb.nodetable.mapping.id2node");
        String nodesdata = metafile.getProperty("tdb.nodetable.mapping.data");
        log.debug("Object table: " + indexNode2Id + " - " + indexId2Node);
        int n2idCacheSize = PropertyUtils.getPropertyAsInteger((Properties)config, (String)"tdb.cache.node2nodeid.size");
        int id2nCacheSize = PropertyUtils.getPropertyAsInteger((Properties)config, (String)"tdb.cache.nodeid2node.size");
        NodeTable nodeTable = SetupTDB.makeNodeTable(location, indexNode2Id, n2idCacheSize, indexId2Node, id2nCacheSize);
        ConcurrencyPolicy policy = SetupTDB.createConcurrencyPolicy();
        TripleTable tripleTable = SetupTDB.makeTripleTable(location, config, nodeTable, "SPO", Names.tripleIndexes, policy);
        QuadTable quadTable = SetupTDB.makeQuadTable(location, config, nodeTable, "GSPO", Names.quadIndexes, policy);
        DatasetPrefixStorage prefixes = SetupTDB.makePrefixes(location, config, policy);
        DatasetGraphTDB dsg = new DatasetGraphTDB(tripleTable, quadTable, prefixes, SetupTDB.chooseOptimizer(location), location, config);
        metafile.flush();
        if (localProperties && (unionDefaultGraph = PropertyUtils.getPropertyAsBoolean((Properties)config, (String)(key = (base = "tdb.feature.") + TDB.symUnionDefaultGraph.getSymbol()), (boolean)false))) {
            dsg.getContext().setTrue(TDB.symUnionDefaultGraph);
        }
        return dsg;
    }

    protected static ConcurrencyPolicy createConcurrencyPolicy() {
        return new ConcurrencyPolicyMRSW();
    }

    public static TripleTable makeTripleTable(Location location, Properties config, NodeTable nodeTable, String dftPrimary, String[] dftIndexes, ConcurrencyPolicy policy) {
        MetaFile metafile = location.getMetaFile();
        String primary = metafile.getOrSetDefault("tdb.indexes.triples.primary", dftPrimary);
        String x = metafile.getOrSetDefault("tdb.indexes.triples", StrUtils.strjoin((String)",", (String[])dftIndexes));
        String[] indexes = x.split(",");
        if (indexes.length != 3) {
            SetupTDB.error(log, "Wrong number of triple table indexes: " + StrUtils.strjoin((String)",", (String[])indexes));
        }
        log.debug("Triple table: " + primary + " :: " + StrUtils.strjoin((String)",", (String[])indexes));
        TupleIndex[] tripleIndexes = SetupTDB.makeTupleIndexes(location, config, primary, indexes, indexes);
        if (tripleIndexes.length != indexes.length) {
            SetupTDB.error(log, "Wrong number of triple table tuples indexes: " + tripleIndexes.length);
        }
        TripleTable tripleTable = new TripleTable(tripleIndexes, nodeTable, policy);
        metafile.flush();
        return tripleTable;
    }

    public static QuadTable makeQuadTable(Location location, Properties config, NodeTable nodeTable, String dftPrimary, String[] dftIndexes, ConcurrencyPolicy policy) {
        MetaFile metafile = location.getMetaFile();
        String primary = metafile.getOrSetDefault("tdb.indexes.quads.primary", dftPrimary);
        String x = metafile.getOrSetDefault("tdb.indexes.quads", StrUtils.strjoin((String)",", (String[])dftIndexes));
        String[] indexes = x.split(",");
        if (indexes.length != 6) {
            SetupTDB.error(log, "Wrong number of quad table indexes: " + StrUtils.strjoin((String)",", (String[])indexes));
        }
        log.debug("Quad table: " + primary + " :: " + StrUtils.strjoin((String)",", (String[])indexes));
        TupleIndex[] quadIndexes = SetupTDB.makeTupleIndexes(location, config, primary, indexes, indexes);
        if (quadIndexes.length != indexes.length) {
            SetupTDB.error(log, "Wrong number of quad table tuples indexes: " + quadIndexes.length);
        }
        QuadTable quadTable = new QuadTable(quadIndexes, nodeTable, policy);
        metafile.flush();
        return quadTable;
    }

    public static DatasetPrefixStorage makePrefixes(Location location, Properties config, ConcurrencyPolicy policy) {
        MetaFile metafile = location.getMetaFile();
        String indexPrefixes = metafile.getOrSetDefault("tdb.prefixes.index.file", "prefixIdx");
        String primary = metafile.getOrSetDefault("tdb.prefixes.primary", "GPU");
        String x = metafile.getOrSetDefault("tdb.prefixes.indexes", StrUtils.strjoin((String)",", (String[])Names.prefixIndexes));
        String[] indexes = x.split(",");
        TupleIndex[] prefixIndexes = SetupTDB.makeTupleIndexes(location, config, primary, indexes, new String[]{indexPrefixes});
        if (prefixIndexes.length != indexes.length) {
            SetupTDB.error(log, "Wrong number of triple table tuples indexes: " + prefixIndexes.length);
        }
        String pnNode2Id = metafile.getOrSetDefault("tdb.prefixes.nodetable.mapping.node2id", "prefix2id");
        String pnId2Node = metafile.getOrSetDefault("tdb.prefixes.nodetable.mapping.id2node", "prefixes");
        NodeTable prefixNodes = SetupTDB.makeNodeTable(location, pnNode2Id, -1, pnId2Node, -1);
        DatasetPrefixesTDB prefixes = new DatasetPrefixesTDB(prefixIndexes, prefixNodes, policy);
        log.debug("Prefixes: " + x);
        return prefixes;
    }

    public static TupleIndex[] makeTupleIndexes(Location location, Properties config, String primary, String[] descs, String[] filenames) {
        if (primary.length() != 3 && primary.length() != 4) {
            SetupTDB.error(log, "Bad primary key length: " + primary.length());
        }
        int indexRecordLen = primary.length() * 8;
        TupleIndex[] indexes = new TupleIndex[descs.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = SetupTDB.makeTupleIndex(location, config, primary, descs[i], filenames[i], indexRecordLen);
        }
        return indexes;
    }

    public static TupleIndex makeTupleIndex(Location location, Properties config, String primary, String indexOrder, String indexName, int keyLength) {
        FileSet fs = new FileSet(location, indexName);
        MetaFile metafile = fs.getMetaFile();
        metafile.checkOrSetMetadata("tdb.file.type", "rangeindex");
        metafile.checkOrSetMetadata("tdb.file.indexorder", indexOrder);
        int readCacheSize = PropertyUtils.getPropertyAsInteger((Properties)config, (String)"tdb.cache.blockread.size");
        int writeCacheSize = PropertyUtils.getPropertyAsInteger((Properties)config, (String)"tdb.cache.blockwrite.size");
        RangeIndex rIndex = SetupTDB.makeRangeIndex(location, indexName, keyLength, 0, readCacheSize, writeCacheSize);
        TupleIndexRecord tupleIndex = new TupleIndexRecord(primary.length(), new ColumnMap(primary, indexOrder), rIndex.getRecordFactory(), rIndex);
        metafile.flush();
        return tupleIndex;
    }

    public static Index makeIndex(Location location, String indexName, int dftKeyLength, int dftValueLength, int readCacheSize, int writeCacheSize) {
        return SetupTDB.makeRangeIndex(location, indexName, dftKeyLength, dftValueLength, readCacheSize, writeCacheSize);
    }

    public static RangeIndex makeRangeIndex(Location location, String indexName, int dftKeyLength, int dftValueLength, int readCacheSize, int writeCacheSize) {
        FileSet fs = new FileSet(location, indexName);
        MetaFile metafile = fs.getMetaFile();
        metafile.checkOrSetMetadata("tdb.file.type", "rangeindex");
        String indexType = metafile.getOrSetDefault("tdb.file.impl", "bplustree");
        if (!indexType.equals("bplustree")) {
            log.error("Unknown index type: " + indexType);
            throw new TDBException("Unknown index type: " + indexType);
        }
        metafile.checkOrSetMetadata("tdb.file.impl.version", "bplustree-v1");
        RangeIndex rIndex = SetupTDB.makeBPlusTree(fs, readCacheSize, writeCacheSize, dftKeyLength, dftValueLength);
        metafile.flush();
        return rIndex;
    }

    public static RangeIndex makeBPlusTree(FileSet fs, int readCacheSize, int writeCacheSize, int dftKeyLength, int dftValueLength) {
        MetaFile metafile = fs.getMetaFile();
        RecordFactory recordFactory = SetupTDB.makeRecordFactory(metafile, "tdb.bplustree.record", dftKeyLength, dftValueLength);
        String blkSizeStr = metafile.getOrSetDefault("tdb.bplustree.blksize", Integer.toString(8192));
        int blkSize = SetupTDB.parseInt(blkSizeStr, "Bad block size");
        int calcOrder = BPlusTreeParams.calcOrder(blkSize, recordFactory.recordLength());
        String orderStr = metafile.getOrSetDefault("tdb.bplustree.order", Integer.toString(calcOrder));
        int order = SetupTDB.parseInt(orderStr, "Bad order for B+Tree");
        if (order != calcOrder) {
            SetupTDB.error(log, "Wrong order (" + order + "), calculated = " + calcOrder);
        }
        RangeIndex rIndex = SetupTDB.createBPTree(fs, order, blkSize, readCacheSize, writeCacheSize, recordFactory);
        metafile.flush();
        return rIndex;
    }

    public static RecordFactory makeRecordFactory(MetaFile metafile, String keyName, int keyLenDft, int valLenDft) {
        String[] recordLengths;
        String recSizeStr = null;
        if (keyLenDft >= 0 && valLenDft >= 0) {
            String dftRecordStr = keyLenDft + "," + valLenDft;
            recSizeStr = metafile.getOrSetDefault(keyName, dftRecordStr);
        } else {
            recSizeStr = metafile.getProperty(keyName);
        }
        if (recSizeStr == null) {
            SetupTDB.error(log, "Failed to get a record factory description from " + keyName);
        }
        if ((recordLengths = recSizeStr.split(",")).length != 2) {
            SetupTDB.error(log, "Bad record length: " + recSizeStr);
        }
        int keyLen = SetupTDB.parseInt(recordLengths[0], "Bad key length (" + recSizeStr + ")");
        int valLen = SetupTDB.parseInt(recordLengths[1], "Bad value length (" + recSizeStr + ")");
        return new RecordFactory(keyLen, valLen);
    }

    public static NodeTable makeNodeTableBase(Location location, String indexNode2Id, String indexId2Node) {
        if (location.isMem()) {
            return NodeTableFactory.createMem(IndexBuilder.mem());
        }
        String nodeTableType = location.getMetaFile().getProperty(Names.kNodeTableType);
        if (nodeTableType != null) {
            if (!nodeTableType.equals(NodeTableType)) {
                log.debug("Explicit node table type: " + nodeTableType + " (ignored)");
            }
        } else {
            location.getMetaFile().setProperty(Names.kNodeTableType, NodeTableType);
            location.getMetaFile().setProperty(Names.kNodeTableLayout, NodeTableLayout);
        }
        FileSet fsIdToNode = new FileSet(location, indexId2Node);
        ObjectFile stringFile = SetupTDB.makeObjectFile(fsIdToNode);
        Index nodeToId = SetupTDB.makeIndex(location, indexNode2Id, 16, 8, -1, -1);
        NodeTableNative nodeTable = new NodeTableNative(nodeToId, stringFile);
        return nodeTable;
    }

    public static NodeTable makeNodeTable(Location location, String indexNode2Id, int nodeToIdCacheSize, String indexId2Node, int idToNodeCacheSize) {
        NodeTable nodeTable = SetupTDB.makeNodeTableBase(location, indexNode2Id, indexId2Node);
        nodeTable = NodeTableCache.create(nodeTable, nodeToIdCacheSize, idToNodeCacheSize);
        nodeTable = NodeTableInline.create(nodeTable);
        return nodeTable;
    }

    public static ObjectFile makeObjectFile(FileSet fsIdToNode) {
        MetaFile metafile = fsIdToNode.getMetaFile();
        metafile.checkOrSetMetadata("tdb.file.type", "object");
        metafile.checkOrSetMetadata("tdb.file.impl", NodeTableType);
        metafile.checkOrSetMetadata("tdb.file.impl.version", "dat-v1");
        metafile.checkOrSetMetadata("tdb.object.encoding", "sse");
        String filename = fsIdToNode.filename(NodeTableType);
        ObjectFile objFile = FileFactory.createObjectFileDisk(filename);
        metafile.flush();
        return objFile;
    }

    public static MetaFile locationMetadata(Location location) {
        boolean newDataset = location.isMem() || !FileOps.existsAnyFiles((String)location.getDirectoryPath());
        MetaFile metafile = location.getMetaFile();
        boolean isPreMetadata = false;
        if (!newDataset && metafile.existsMetaData()) {
            String verString = metafile.getProperty("tdb.create.version", "unknown");
            TDB.logInfo.debug("Location: " + location.toString());
            TDB.logInfo.debug("Version:  " + verString);
        } else if (!newDataset) {
            isPreMetadata = FileOps.exists((String)location.getPath("SPO.idn"));
        }
        if (newDataset) {
            metafile.ensurePropertySet("tdb.create.version", TDB.VERSION);
            metafile.ensurePropertySet("tdb.created", Utils.nowAsXSDDateTimeString());
        }
        if (isPreMetadata) {
            metafile.ensurePropertySet("tdb.create.version", "0.8");
            metafile.setProperty(Names.kCreatedDate, Utils.nowAsXSDDateTimeString());
        }
        metafile.ensurePropertySet("tdb.layout", "v1");
        metafile.ensurePropertySet("tdb.type", "standalone");
        String layout = metafile.getProperty("tdb.layout");
        if (layout.equals("v1")) {
            metafile.ensurePropertySet("tdb.indexes.triples.primary", "SPO");
            metafile.ensurePropertySet("tdb.indexes.triples", StrUtils.strjoin((String)",", (String[])Names.tripleIndexes));
            metafile.ensurePropertySet("tdb.indexes.quads.primary", "GSPO");
            metafile.ensurePropertySet("tdb.indexes.quads", StrUtils.strjoin((String)",", (String[])Names.quadIndexes));
            metafile.ensurePropertySet("tdb.nodetable.mapping.node2id", "node2id");
            metafile.ensurePropertySet("tdb.nodetable.mapping.id2node", "nodes");
            metafile.ensurePropertySet("tdb.prefixes.index.file", "prefixIdx");
            metafile.ensurePropertySet("tdb.prefixes.nodetable.mapping.node2id", "prefix2id");
            metafile.ensurePropertySet("tdb.prefixes.nodetable.mapping.id2node", "prefixes");
        } else {
            SetupTDB.error(log, "tdb.layout: expected v1");
        }
        metafile.flush();
        return metafile;
    }

    public static RangeIndex createBPTree(FileSet fileset, int order, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        int order2;
        if (blockSize < 0 && order < 0) {
            throw new IllegalArgumentException("Neither blocksize nor order specified");
        }
        if (blockSize >= 0 && order < 0) {
            order = BPlusTreeParams.calcOrder(blockSize, factory.recordLength());
        }
        if (blockSize >= 0 && order >= 0 && order != (order2 = BPlusTreeParams.calcOrder(blockSize, factory.recordLength()))) {
            throw new IllegalArgumentException("Wrong order (" + order + "), calculated = " + order2);
        }
        if (blockSize < 0 && order >= 0) {
            blockSize = BPlusTreeParams.calcBlockSize(order, factory);
        }
        BPlusTreeParams params = new BPlusTreeParams(order, factory);
        BlockMgr blkMgrNodes = BlockMgrFactory.create(fileset, "idn", blockSize, readCacheSize, writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create(fileset, NodeTableType, blockSize, readCacheSize, writeCacheSize);
        return BPlusTree.attach(params, blkMgrNodes, blkMgrRecords);
    }

    public static void setOptimizerWarningFlag(boolean b) {
        warnAboutOptimizer = b;
    }

    public static ReorderTransformation chooseOptimizer(Location location) {
        if (location == null) {
            return ReorderLib.identity();
        }
        ReorderTransformation reorder = null;
        if (location.exists("stats.opt")) {
            try {
                reorder = ReorderLib.weighted((String)location.getPath("stats.opt"));
                TDB.logInfo.debug("Statistics-based BGP optimizer");
            }
            catch (SSEParseException ex) {
                log.warn("Error in stats file: " + ex.getMessage());
                reorder = null;
            }
        }
        if (reorder == null && location.exists("fixed.opt")) {
            reorder = ReorderLib.fixed();
            TDB.logInfo.debug("Fixed pattern BGP optimizer");
        }
        if (location.exists("none.opt")) {
            reorder = ReorderLib.identity();
            TDB.logInfo.debug("Optimizer explicitly turned off");
        }
        if (reorder == null) {
            reorder = SystemTDB.defaultOptimizer;
        }
        if (reorder == null && warnAboutOptimizer) {
            ARQ.getExecLogger().warn("No BGP optimizer");
        }
        return reorder;
    }

    public static void error(Logger log, String msg) {
        if (log != null) {
            log.error(msg);
        }
        throw new TDBException(msg);
    }

    public static int parseInt(String str, String messageBase) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            SetupTDB.error(log, messageBase + ": " + str);
            return -1;
        }
    }

    static {
        globalConfig.setProperty("tdb.cache.node2nodeid.size", Integer.toString(SystemTDB.Node2NodeIdCacheSize));
        globalConfig.setProperty("tdb.cache.nodeid2node.size", Integer.toString(SystemTDB.NodeId2NodeCacheSize));
        globalConfig.setProperty("tdb.cache.blockwrite.size", Integer.toString(SystemTDB.BlockWriteCacheSize));
        globalConfig.setProperty("tdb.cache.blockread.size", Integer.toString(SystemTDB.BlockReadCacheSize));
        systemInfo = new TDBSystemInfoMBean(){

            public int getSyncTick() {
                return this.getIntProperty("tdb.synctick");
            }

            public int getSegmentSize() {
                return 0x800000;
            }

            public int getNodeId2NodeCacheSize() {
                return this.getIntProperty("tdb.cache.nodeid2node.size");
            }

            public int getNode2NodeIdCacheSize() {
                return this.getIntProperty("tdb.cache.node2nodeid.size");
            }

            public int getBlockWriteCacheSize() {
                return this.getIntProperty("tdb.cache.blockwrite.size");
            }

            public int getBlockSize() {
                return 8192;
            }

            public int getBlockReadCacheSize() {
                return this.getIntProperty("tdb.cache.blockread.size");
            }

            private int getIntProperty(String name) {
                return Integer.parseInt(globalConfig.getProperty(name));
            }
        };
        warnAboutOptimizer = true;
    }
}

