/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.sparql.util.Timer;
import java.util.Date;
import org.openjena.atlas.lib.Sink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkProgress<X>
implements Sink<X> {
    Timer timer = null;
    private long lastTime = 0L;
    private boolean displayMemory = false;
    String label = null;
    String summaryLabel = null;
    private String format;
    private long totalCount = 0L;
    private long tickCount = 0L;
    private int batchInterval = 0;
    private String units;
    private boolean showProgress;

    public SinkProgress(String label, String units, int interval, boolean showProgress) {
        this.label = label;
        this.units = units;
        this.batchInterval = interval;
        this.showProgress = showProgress;
        this.format = "Add: %,d %s (Batch: %,d / Run: %,d)";
        this.timer = new Timer();
        this.timer.startTimer();
    }

    public long getCount() {
        return this.totalCount;
    }

    public void flush() {
    }

    public void close() {
        this.printAtEnd();
    }

    public void startMonitor() {
        this.resetTimer();
    }

    public void finishMonitor() {
        if (this.timer != null) {
            this.timer.endTimer();
        }
    }

    public void resetTimer() {
        if (this.timer != null) {
            this.timer.endTimer();
        }
        this.timer = new Timer();
        this.timer.startTimer();
    }

    public void send(X item) {
        this.oneItem();
    }

    protected void oneItem() {
        ++this.totalCount;
        if (this.totalCount != 0L && this.totalCount % (long)this.batchInterval == 0L) {
            ++this.tickCount;
            if (this.showProgress) {
                this.oneTickDisplay();
            }
        }
    }

    protected void oneTickDisplay() {
        long soFar = this.timer.readTimer();
        long thisTime = soFar - this.lastTime;
        long tpsBatch = (long)this.batchInterval * 1000L / thisTime;
        long tpsAvg = this.totalCount * 1000L / soFar;
        String msg = String.format(this.format, this.totalCount, this.units, tpsBatch, tpsAvg);
        if (this.displayMemory) {
            long mem = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            msg = msg + String.format("   [M:%,d/F:%,d]", mem, free);
        }
        SinkProgress.println(this.label, msg);
        if (this.tickCount > 0L && this.tickCount % 10L == 0L) {
            String timestamp = StringUtils.str((Date)new Date());
            String msg2 = String.format("  Elapsed: %f.2f seconds [%s]", Float.valueOf((float)soFar / 1000.0f), timestamp);
            SinkProgress.println(this.label, msg2);
        }
        this.lastTime = soFar;
    }

    private void printAtEnd() {
        long timeMilli = this.timer.getTimeInterval();
        String x = String.format("%,d %s: loaded in %,.2f seconds [%,.2f %s/s]", this.totalCount, this.units, Float.valueOf((float)timeMilli / 1000.0f), Float.valueOf(1000.0f * (float)this.totalCount / (float)timeMilli), this.units);
        SinkProgress.println(this.summaryLabel, x);
    }

    private static void println(String label, String msg) {
        if (label != null) {
            System.out.print(label);
        }
        System.out.println(msg);
    }
}

