/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Reifier2;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.graph.GraphBase2;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.graph.BulkUpdateHandlerTDB;
import com.hp.hpl.jena.tdb.graph.QueryHandlerTDB;
import com.hp.hpl.jena.tdb.graph.TransactionHandlerTDB;
import com.hp.hpl.jena.tdb.lib.NodeFmtLib;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import org.openjena.atlas.iterator.Iter;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphTDBBase
extends GraphBase2
implements GraphTDB {
    private final QueryHandlerTDB queryHandler = new QueryHandlerTDB(this);
    private final TransactionHandler transactionHandler = new TransactionHandlerTDB(this);
    private final BulkUpdateHandler bulkUpdateHandler = new BulkUpdateHandlerTDB(this);
    protected final DatasetGraphTDB dataset;
    protected final Node graphNode;

    public GraphTDBBase(DatasetGraphTDB dataset, Node graphName) {
        this.dataset = dataset;
        this.graphNode = graphName;
    }

    public final ReorderTransformation getReorderTransform() {
        return this.dataset.getTransform();
    }

    @Override
    public final Location getLocation() {
        return this.dataset.getLocation();
    }

    @Override
    public final Node getGraphNode() {
        return this.graphNode;
    }

    @Override
    public final DatasetGraphTDB getDataset() {
        return this.dataset;
    }

    @Override
    public Lock getLock() {
        return this.dataset.getLock();
    }

    public final void performAdd(Triple triple) {
        this.startUpdate();
        this._performAdd(triple);
        this.finishUpdate();
    }

    public final void performDelete(Triple triple) {
        this.startUpdate();
        this._performDelete(triple);
        this.finishUpdate();
    }

    protected abstract boolean _performAdd(Triple var1);

    protected abstract boolean _performDelete(Triple var1);

    public abstract void sync();

    public abstract String toString();

    protected void duplicate(Triple t) {
        if (TDB.getContext().isTrue(SystemTDB.symLogDuplicates) && this.getLog().isInfoEnabled()) {
            String $ = NodeFmtLib.displayStr(t, this.getPrefixMapping());
            this.getLog().info("Duplicate: (" + $ + ")");
        }
    }

    protected static ExtendedIterator<Triple> graphBaseFindWorker(TripleTable tripleTable, TripleMatch m) {
        Iterator<Triple> iter = tripleTable.find(m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
        if (iter == null) {
            return NullIterator.instance();
        }
        boolean b = iter.hasNext();
        return WrappedIterator.createNoRemove(iter);
    }

    protected static ExtendedIterator<Triple> graphBaseFindWorker(DatasetGraphTDB dataset, Node graphNode, TripleMatch m) {
        Iterator<Quad> iter;
        Node gn = graphNode;
        if (Quad.isUnionGraph((Node)gn)) {
            gn = Node.ANY;
        }
        if ((iter = dataset.getQuadTable().find(gn, m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject())) == null) {
            return NullIterator.instance();
        }
        Iterator<Triple> iterTriples = new ProjectQuadsToTriples(gn == Node.ANY ? null : gn, iter);
        if (gn == Node.ANY) {
            iterTriples = Iter.distinct((Iterator)iterTriples);
        }
        return WrappedIterator.createNoRemove((Iterator)iterTriples);
    }

    protected Reifier constructReifier() {
        return new Reifier2((Graph)this);
    }

    protected abstract Logger getLog();

    protected abstract Iterator<?> countThis();

    @Override
    public void startRead() {
        this.dataset.startRead();
    }

    @Override
    public void finishRead() {
        this.dataset.finishRead();
    }

    @Override
    public final void startUpdate() {
        this.dataset.startUpdate();
    }

    @Override
    public final void finishUpdate() {
        this.dataset.finishUpdate();
    }

    protected final int graphBaseSize() {
        Iterator<?> iter = this.countThis();
        return (int)Iter.count(iter);
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        return this.bulkUpdateHandler;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new Capabilities(){

                public boolean sizeAccurate() {
                    return true;
                }

                public boolean addAllowed() {
                    return true;
                }

                public boolean addAllowed(boolean every) {
                    return true;
                }

                public boolean deleteAllowed() {
                    return true;
                }

                public boolean deleteAllowed(boolean every) {
                    return true;
                }

                public boolean canBeEmpty() {
                    return true;
                }

                public boolean iteratorRemoveAllowed() {
                    return false;
                }

                public boolean findContractSafe() {
                    return true;
                }

                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return super.getCapabilities();
    }

    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProjectQuadsToTriples
    implements Iterator<Triple> {
        private final Iterator<Quad> iter;
        private final Node graphNode;

        ProjectQuadsToTriples(Node graphNode, Iterator<Quad> iter) {
            this.graphNode = graphNode;
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Triple next() {
            Quad q = this.iter.next();
            if (this.graphNode != null && !q.getGraph().equals((Object)this.graphNode)) {
                throw new InternalError("ProjectQuadsToTriples: Quads from unexpected graph");
            }
            return q.asTriple();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

