/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetPrefixStorage;
import com.hp.hpl.jena.sparql.graph.GraphPrefixesProjection;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexRecord;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTableFactory;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTableConcrete;
import com.hp.hpl.jena.tdb.sys.ConcurrencyPolicy;
import com.hp.hpl.jena.tdb.sys.ConcurrencyPolicyMRSW;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.ColumnMap;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetPrefixesTDB
implements DatasetPrefixStorage {
    static final String unamedGraphURI = "";
    private final NodeTupleTable nodeTupleTable;
    static final ColumnMap colMap = new ColumnMap("GPU", "GPU");
    public static final RecordFactory factory = new RecordFactory(24, 0);

    @Deprecated
    public static DatasetPrefixesTDB create(Location location, ConcurrencyPolicy policy) {
        return DatasetPrefixesTDB.create(IndexBuilder.get(), location, policy);
    }

    @Deprecated
    public static DatasetPrefixesTDB create(IndexBuilder indexBuilder, Location location, ConcurrencyPolicy policy) {
        return new DatasetPrefixesTDB(indexBuilder, location, policy);
    }

    @Deprecated
    private DatasetPrefixesTDB(IndexBuilder indexBuilder, Location location, ConcurrencyPolicy policy) {
        FileSet filesetGPU = null;
        if (location != null) {
            filesetGPU = new FileSet(location, "prefixIdx");
        }
        TupleIndexRecord index = new TupleIndexRecord(3, colMap, factory, indexBuilder.newRangeIndex(filesetGPU, factory));
        TupleIndex[] indexes = new TupleIndex[]{index};
        FileSet filesetNodeTableIdx = null;
        if (location != null) {
            filesetNodeTableIdx = new FileSet(location, "prefix2id");
        }
        FileSet filesetNodeTable = null;
        if (location != null) {
            filesetNodeTable = new FileSet(location, "prefixes");
        }
        NodeTable nodes = NodeTableFactory.create(indexBuilder, filesetNodeTable, filesetNodeTableIdx, -1, -1);
        this.nodeTupleTable = new NodeTupleTableConcrete(3, indexes, nodes, policy);
    }

    public DatasetPrefixesTDB(TupleIndex[] indexes, NodeTable nodes, ConcurrencyPolicy policy) {
        this.nodeTupleTable = new NodeTupleTableConcrete(3, indexes, nodes, policy);
    }

    private DatasetPrefixesTDB() {
        this(IndexBuilder.mem(), Location.mem(), (ConcurrencyPolicy)new ConcurrencyPolicyMRSW());
    }

    public static DatasetPrefixesTDB testing() {
        return new DatasetPrefixesTDB();
    }

    public synchronized void insertPrefix(String graphName, String prefix, String uri) {
        Node g = Node.createURI((String)graphName);
        Node p = Node.createLiteral((String)prefix);
        Node u = Node.createURI((String)uri);
        this.nodeTupleTable.addRow(g, p, u);
    }

    public Set<String> graphNames() {
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(new Node[]{null, null, null});
        HashSet<String> x = new HashSet<String>();
        while (iter.hasNext()) {
            x.add(((Node)iter.next().get(0)).getURI());
        }
        Iter.close(iter);
        return x;
    }

    public synchronized String readPrefix(String graphName, String prefix) {
        Node g = Node.createURI((String)graphName);
        Node p = Node.createLiteral((String)prefix);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, p, null);
        if (!iter.hasNext()) {
            return null;
        }
        Tuple<Node> t = iter.next();
        Node uri = (Node)t.get(2);
        Iter.close(iter);
        return uri.getURI();
    }

    public synchronized String readByURI(String graphName, String uriStr) {
        Node g = Node.createURI((String)graphName);
        Node u = Node.createURI((String)uriStr);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, u);
        if (!iter.hasNext()) {
            return null;
        }
        Node prefix = (Node)iter.next().get(1);
        Iter.close(iter);
        return prefix.getLiteralLexicalForm();
    }

    public synchronized Map<String, String> readPrefixMap(String graphName) {
        Node g = Node.createURI((String)graphName);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, null);
        HashMap<String, String> map = new HashMap<String, String>();
        while (iter.hasNext()) {
            Tuple<Node> t = iter.next();
            String prefix = ((Node)t.get(1)).getLiteralLexicalForm();
            String uri = ((Node)t.get(2)).getURI();
            map.put(prefix, uri);
        }
        Iter.close(iter);
        return map;
    }

    public synchronized void loadPrefixMapping(String graphName, PrefixMapping pmap) {
        Node g = Node.createURI((String)graphName);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, null);
        while (iter.hasNext()) {
            Tuple<Node> t = iter.next();
            String prefix = ((Node)t.get(1)).getLiteralLexicalForm();
            String uri = ((Node)t.get(2)).getURI();
            pmap.setNsPrefix(prefix, uri);
        }
        Iter.close(iter);
    }

    public synchronized void removeFromPrefixMap(String graphName, String prefix, String uri) {
        Node g = Node.createURI((String)graphName);
        Node p = Node.createLiteral((String)prefix);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, p, null);
        while (iter.hasNext()) {
            this.nodeTupleTable.deleteRow(g, p, (Node)iter.next().get(2));
        }
        Iter.close(iter);
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.nodeTupleTable;
    }

    public PrefixMapping getPrefixMapping() {
        return this.getPrefixMapping(unamedGraphURI);
    }

    public PrefixMapping getPrefixMapping(String graphName) {
        return new GraphPrefixesProjection(graphName, (DatasetPrefixStorage)this);
    }

    public void close() {
        this.nodeTupleTable.close();
    }

    public void sync() {
        this.nodeTupleTable.sync();
    }
}

