/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.migrate;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphMap;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.migrate.DatasetGraphReadOnly;
import com.hp.hpl.jena.tdb.migrate.GraphOps;
import com.hp.hpl.jena.tdb.migrate.GraphUnionRead;
import com.hp.hpl.jena.tdb.migrate.NodeUtils2;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicDatasets {
    public static DatasetGraph dynamicDataset(Query query2, DatasetGraph dsg, boolean defaultUnionGraph) {
        if (query2.hasDatasetDescription()) {
            Set<Node> defaultGraphs = NodeUtils2.convertToNodes(query2.getGraphURIs());
            Set<Node> namedGraphs = NodeUtils2.convertToNodes(query2.getNamedGraphURIs());
            return DynamicDatasets.dynamicDataset(defaultGraphs, namedGraphs, dsg, defaultUnionGraph);
        }
        return dsg;
    }

    public static Dataset dynamicDataset(Query query2, Dataset ds, boolean defaultUnionGraph) {
        DatasetGraph dsg2;
        DatasetGraph dsg = ds.asDatasetGraph();
        if (dsg == (dsg2 = DynamicDatasets.dynamicDataset(query2, dsg, defaultUnionGraph))) {
            return ds;
        }
        return DatasetFactory.create((DatasetGraph)dsg2);
    }

    public static DatasetGraph dynamicDataset(Collection<Node> defaultGraphs, Collection<Node> namedGraphs, DatasetGraph dsg, boolean defaultUnionGraph) {
        GraphUnionRead dft = new GraphUnionRead(dsg, defaultGraphs);
        Object dsg2 = new DatasetGraphMap((Graph)dft);
        for (Node gn : namedGraphs) {
            Graph g = GraphOps.getGraph(dsg, gn);
            if (g == null) continue;
            dsg2.addGraph(gn, g);
        }
        if (dsg.getContext() != null) {
            dsg2.getContext().putAll(dsg.getContext());
        }
        if (defaultUnionGraph && defaultGraphs.size() == 0) {
            GraphUnionRead unionGraph = new GraphUnionRead(dsg, namedGraphs);
            dsg2.setDefaultGraph((Graph)unionGraph);
        }
        dsg2 = new DynamicDatasetGraph((DatasetGraph)dsg2);
        return dsg2;
    }

    public static class DynamicDatasetGraph
    extends DatasetGraphReadOnly {
        private Graph unionGraph = null;

        public DynamicDatasetGraph(DatasetGraph dsg) {
            super(dsg);
        }

        public Graph getGraph(Node graphNode) {
            if (Quad.isUnionGraph((Node)graphNode)) {
                if (this.unionGraph == null) {
                    this.unionGraph = GraphOps.unionGraph(super.getWrapped());
                }
                return this.unionGraph;
            }
            if (Quad.isDefaultGraphExplicit((Node)graphNode)) {
                return this.getDefaultGraph();
            }
            return super.getGraph(graphNode);
        }
    }
}

