/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.serdes.avro.AbstractAvroSerDesProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.ConfluentAvroSerDesHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroException;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroRetryableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentProtocolHandler
extends AbstractAvroSerDesProtocolHandler {
    public static final Logger LOG = LoggerFactory.getLogger(ConfluentProtocolHandler.class);

    public ConfluentProtocolHandler() {
        super((byte)0, new ConfluentAvroSerDesHandler());
    }

    @Override
    protected void doHandleSchemaVersionSerialization(OutputStream outputStream, SchemaIdVersion schemaIdVersion) {
        Long versionId = schemaIdVersion.getSchemaVersionId();
        if (versionId > Integer.MAX_VALUE) {
            throw new AvroException("Unsupported versionId, max id=2147483647 , but was id=" + versionId);
        }
        try {
            outputStream.write(ByteBuffer.allocate(4).putInt(versionId.intValue()).array());
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
    }

    @Override
    public SchemaIdVersion handleSchemaVersionDeserialization(InputStream inputStream) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            inputStream.read(byteBuffer.array());
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
        int schemaVersionId = byteBuffer.getInt();
        return new SchemaIdVersion(Long.valueOf(schemaVersionId));
    }
}

