/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.serdes.avro.AbstractAvroSnapshotDeserializer;
import com.hortonworks.registries.schemaregistry.serdes.avro.SerDesProtocolHandlerRegistry;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroException;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroRetryableException;
import java.io.IOException;
import java.io.InputStream;

public class AvroSnapshotDeserializer
extends AbstractAvroSnapshotDeserializer<InputStream> {
    public AvroSnapshotDeserializer() {
    }

    public AvroSnapshotDeserializer(ISchemaRegistryClient schemaRegistryClient) {
        super(schemaRegistryClient);
    }

    protected SchemaIdVersion retrieveSchemaIdVersion(byte protocolId, InputStream inputStream) throws SerDesException {
        return SerDesProtocolHandlerRegistry.get().getSerDesProtocolHandler(protocolId).handleSchemaVersionDeserialization(inputStream);
    }

    protected byte retrieveProtocolId(InputStream inputStream) throws SerDesException {
        byte protocolId;
        try {
            protocolId = (byte)inputStream.read();
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
        if (protocolId == -1) {
            throw new AvroException("End of stream reached while trying to read protocol id");
        }
        this.checkProtocolHandlerExists(protocolId);
        return protocolId;
    }

    private void checkProtocolHandlerExists(byte protocolId) {
        if (SerDesProtocolHandlerRegistry.get().getSerDesProtocolHandler(protocolId) == null) {
            throw new AvroException("Unknown protocol id [" + protocolId + "] received while deserializing the payload");
        }
    }

    protected Object doDeserialize(InputStream payloadInputStream, byte protocolId, SchemaMetadata schemaMetadata, Integer writerSchemaVersion, Integer readerSchemaVersion) throws SerDesException {
        return this.buildDeserializedObject(protocolId, payloadInputStream, schemaMetadata, writerSchemaVersion, readerSchemaVersion);
    }
}

