/*
 * #%L
 * SGQ :: Business
 * $Id: PresentationCode.java 406 2013-06-25 09:02:24Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-business/src/main/java/com/herbocailleau/sgq/entities/PresentationCode.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

/**
 * Ensemble des code presentation existant dans l'herboristerie cailleau.
 * 
 * @author echatellier
 */
public enum PresentationCode {

    _('.', "Plante stockée ou vendue en l'état ou en coupe standard"),
    A('A', "Plante vendue Hors Tarif en l'état ou en coupe standard"),
    B('B', "Plante vendue Hors Tarif en coupe menue"),
    C('C', "Huile essentielle vendues au Tarif"),
    D('D', "Plante vendue Hors Tarif en poudre"),
    E('E', "Plante vendue en sachet fenêtre pharmacie"),
    F('F', "Mélange de plantes vendu selon Formule client"),
    G('G', "Plante vendue sous forme gélules en vrac"),
    H('H', "Plante vendue en sac cellophane Floranjou"),
    I('I', "Plante vendue sous forme d'infusette conditionnée"),
    J('J', "Plante vendue en sachet fenêtre du client"),
    K('K', "Mélange de plantes libres vendu en sachet selon Formule Cailleau"),
    L('L', "Plante vendue sous forme gélule conditionnées en flacon de 100"),
    M('M', "Plante stockée et vendue au Tarif en coupe menue"),
    N('N', "Plante vendue sous forme gélule conditionnées en flacon de 200"),
    O('O', "Plante vendue sous forme gélule conditionnées en flacon de 50"),
    P('P', "Plante stockée et vendue au Tarif en poudre"),
    Q('Q', "Plante vendue en sachet fenêtre Floranjou"),
    S('S', "Plante vendue en sachet gaze"),
    T('T', "Mélange de plantes vendu selon Formule Cailleau"),
    W('W', "Plante Biologique vendue en sachet fenêtre Floranjou");

    static {
        A.equivalence = _;
        B.equivalence = M;
        D.equivalence = P;
    }

    protected char code;

    protected String description;

    /** Equivalence de facturation correspondant à un autre code presentation. */
    protected PresentationCode equivalence;

    private PresentationCode(char code, String description) {
        this.code = code;
        this.description = description;
    }

    public char getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public PresentationCode getEquivalence() {
        return equivalence;
    }

    public static PresentationCode getPresentationCodeFor(char code) {
        PresentationCode result = null;
        if (code == _.code) {
            result = _;
        } else {
            try {
                result = PresentationCode.valueOf(String.valueOf(code));
            } catch (IllegalArgumentException ex) {
                // ca peut arriver, on retourne null dans ce cas
            }
        }
        return result;
    }
}
