/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.SearchModel;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.BatchDAOAbstract;
import com.herbocailleau.sgq.entities.Expedition;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.entities.Production;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.nuiton.topia.TopiaException;

public class BatchDAOImpl<E extends Batch>
extends BatchDAOAbstract<E> {
    public long countOperating() throws TopiaException {
        String query = "select count(*) from " + Batch.class.getName() + " where " + "invalid" + " = false" + " and " + "expiredDate" + " = null";
        Number result = (Number)this.context.findUnique(query, new Object[0]);
        return result.longValue();
    }

    public int getLastBatchNumber(int maxBatchRange) throws TopiaException {
        String query = "select max(number) from " + Batch.class.getName() + " where " + "invalid" + " = false" + " and " + "expiredDate" + " = null" + " and " + "number" + " <= :max";
        Number result = (Number)this.context.findUnique(query, new Object[]{"max", maxBatchRange});
        return result.intValue();
    }

    public int getNextRangeIdBetween(int start, int end) throws TopiaException {
        String query = "select min(main.number) + 1 from " + Batch.class.getName() + " as main" + " where :start < main." + "number" + " and main." + "number" + " < :end" + " and main." + "number" + " + 1 not in " + " (select sub.number from " + Batch.class.getName() + " as sub)";
        Number id = (Number)this.context.findUnique(query, new Object[]{"start", start, "end", end});
        int result = 0;
        result = id == null ? start : id.intValue();
        return result;
    }

    public List<Batch> findAllBetweenNumbers(int start, int end) throws TopiaException {
        String query = " from " + Batch.class.getName() + " where :start <= " + "number" + " and " + "number" + " <= :end" + " and " + "invalid" + " = false" + " and " + "expiredDate" + " = null";
        List result = this.context.findAll(query, new Object[]{"start", start, "end", end});
        return result;
    }

    public List<BatchModel> findAllModel(SearchModel search) throws TopiaException {
        return this.findAllModel(search, 0, -1);
    }

    public List<BatchModel> findAllModel(SearchModel search, int offset, int limit) throws TopiaException {
        String queryPrefix = this.getFindBatchModelQueryPrefix();
        String querySuffix = " order by B.number ASC";
        List beanAndQts = (List)this.performQueryWithFilter(search, queryPrefix, querySuffix, offset, limit);
        ArrayList<BatchModel> results = new ArrayList<BatchModel>(beanAndQts.size());
        for (Object[] beanAndQt : beanAndQts) {
            Batch batch = (Batch)beanAndQt[0];
            Double pres = (Double)beanAndQt[1];
            Double sale = (Double)beanAndQt[2];
            Date dmes = (Date)beanAndQt[3];
            BatchModel model = new BatchModel(batch, pres == null ? 0.0 : pres, sale == null ? 0.0 : sale, dmes);
            results.add(model);
        }
        return results;
    }

    public long findAllCount(SearchModel search) throws TopiaException {
        String queryPrefix = "select count(B)";
        Number result = (Number)this.performQueryWithFilter(search, queryPrefix, "", -1, -1);
        return result.longValue();
    }

    protected String getFindBatchModelQueryPrefix() {
        String query = "select B, (select sum(P.quantity) from " + Presentation.class.getName() + " P where P.batch = B)," + " (select COALESCE(sum(E.quantity),0) from " + Expedition.class.getName() + " E where E.presentation.batch = B)" + " - (select COALESCE(sum(E.quantity),0) from " + Expedition.class.getName() + " E where E.correction.batch = B)," + " (select min(E.date) from " + Expedition.class.getName() + " E where E.presentation.batch = B)";
        return query;
    }

    protected static String getFieldLikeInsensitive(String field1, String field2) {
        String query = "translate(lower(" + field1 + ")," + "'\u00e1\u00e0\u00e2\u00e3\u00e4\u00e5\u0101\u0103\u0105\u00e8\u00e9\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b\u00ec\u00ed\u00ee\u00ef\u00ec\u0129\u012b\u012d\u1e29\u00f3\u00f4\u00f5\u00f6\u014d\u014f\u0151\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u00e4\u00e0\u00e1\u00e2\u00e3\u00e5\u00e6\u00e7\u0107\u0109\u010d\u00f6\u00f2\u00f3\u00f4\u00f5\u00f8\u00fc\u00f9\u00fa\u00fb\u00df\u00e9\u00e8\u00ea\u00eb\u00fd\u00f1\u00ee\u00ec\u00ed\u00ef\u015f'," + "'aaaaaaaaaeeeeeeeeeeiiiiiiiihooooooouuuuuuuuaaaaaaeccccoooooouuuuseeeeyniiiis')" + "like lower(" + field2 + ")";
        return query;
    }

    protected Object performQueryWithFilter(SearchModel search, String queryPrefix, String querySuffix, int offset, int limit) throws TopiaException {
        int index;
        String query = queryPrefix;
        query = query + " from " + Batch.class.getName() + " B";
        query = query + " where invalid != true";
        ArrayList<Object> params = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)search.getQuery())) {
            query = query + " and (B.number = :batch";
            int batch = -1;
            try {
                batch = Integer.parseInt(search.getQuery());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            params.add("batch");
            params.add(batch);
            query = query + " or " + BatchDAOImpl.getFieldLikeInsensitive("B.product.name", ":query");
            query = query + " or " + BatchDAOImpl.getFieldLikeInsensitive("B.product.code", ":query") + ")";
            params.add("query");
            params.add("%" + StringUtils.stripAccents((String)search.getQuery()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)search.getClient())) {
            query = query + " and (" + BatchDAOImpl.getFieldLikeInsensitive("B.dedicatedClient.code", ":clientcode");
            params.add("clientcode");
            params.add("%" + StringUtils.stripAccents((String)search.getClient()) + "%");
            query = query + " or " + BatchDAOImpl.getFieldLikeInsensitive("B.dedicatedClient.name", ":client") + ")";
            params.add("client");
            params.add("%" + StringUtils.stripAccents((String)search.getClient()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)search.getSupplier())) {
            query = query + " and (" + BatchDAOImpl.getFieldLikeInsensitive("B.supplier.code", ":suppliercode");
            params.add("suppliercode");
            params.add("%" + StringUtils.stripAccents((String)search.getSupplier()) + "%");
            query = query + " or " + BatchDAOImpl.getFieldLikeInsensitive("B.supplier.name", ":supplier") + ")";
            params.add("supplier");
            params.add("%" + StringUtils.stripAccents((String)search.getSupplier()) + "%");
        }
        if (search.getOrigin() != null) {
            query = query + " and B.origin = :origin";
            params.add("origin");
            params.add(search.getOrigin());
        }
        if (CollectionUtils.isNotEmpty(search.getProductStatus())) {
            index = 0;
            query = query + " and (1=1";
            for (ProductStatus status : search.getProductStatus()) {
                if (status == null) {
                    query = query + " AND B.product.productStatus IS EMPTY";
                    continue;
                }
                query = query + " AND :status" + index + " member of B.product.productStatus";
                params.add("status" + index);
                params.add(status);
                ++index;
            }
            query = query + ")";
        }
        if (CollectionUtils.isNotEmpty(search.getProductCategories())) {
            index = 0;
            query = query + " and (0=1";
            for (String cat : search.getProductCategories()) {
                query = query + " OR :category" + index + " = B.product.category";
                params.add("category" + index);
                params.add(cat);
                ++index;
            }
            query = query + ")";
        }
        if (CollectionUtils.isNotEmpty(search.getAnalyzeTypes())) {
            index = 0;
            query = query + " and (";
            Iterator<AnalyzeType> itAnalyzeType = search.getAnalyzeTypes().iterator();
            while (itAnalyzeType.hasNext()) {
                AnalyzeType analyzeType = itAnalyzeType.next();
                query = query + " (B in (select A.batch from " + BatchAnalyze.class.getName() + " A WHERE A.analyzeType = :analyzeType" + index;
                if (search.getSynthesisMention() != null) {
                    query = query + " AND A.synthesisMention = :synthesisMention" + index;
                    params.add("synthesisMention" + index);
                    params.add((Object)search.getSynthesisMention());
                }
                query = query + "))";
                params.add("analyzeType" + index);
                params.add(analyzeType);
                ++index;
                if (!itAnalyzeType.hasNext()) continue;
                query = query + (search.isAnalyzeTypeOrOperator() ? " OR" : " AND");
            }
            query = query + ")";
        } else if (search.getSynthesisMention() != null) {
            query = query + " AND B in (select A.batch from " + BatchAnalyze.class.getName() + " A WHERE A.synthesisMention = :synthesisMention)";
            params.add("synthesisMention");
            params.add((Object)search.getSynthesisMention());
        }
        if (search.getDateType() != null && (search.getBeginDate() != null || search.getEndDate() != null)) {
            String dateField = null;
            switch (search.getDateType()) {
                case ENTRY_DATE: {
                    dateField = "entryDate";
                    break;
                }
                case DLUO: {
                    dateField = "dluo";
                    break;
                }
                case DMES: {
                    dateField = "(select min(S.date) from " + Expedition.class.getName() + " S where S.presentation.batch = B)";
                    break;
                }
                case DMESD: {
                    dateField = "dmesd";
                    break;
                }
                case DPMES: {
                    dateField = "dpmes";
                    break;
                }
                case EXPIRED_DATE: {
                    dateField = "expiredDate";
                }
            }
            if (search.getBeginDate() != null) {
                query = query + " AND :beginDate <= " + dateField;
                params.add("beginDate");
                params.add(search.getBeginDate());
            }
            if (search.getEndDate() != null) {
                Date date = DateUtils.addDays((Date)search.getEndDate(), (int)1);
                date = DateUtils.addMilliseconds((Date)date, (int)-1);
                query = query + " AND " + dateField + " <= :endDate";
                params.add("endDate");
                params.add(date);
            }
        }
        switch (search.getExpired()) {
            case EXPIRED: {
                query = query + " and expiredDate != null";
                break;
            }
            case NON_EXPIRED: {
                query = query + " and expiredDate = null";
                break;
            }
        }
        query = query + querySuffix;
        Object result = null;
        result = offset == -1 ? this.context.findUnique(query, params.toArray()) : (limit == -1 ? this.context.findAll(query, params.toArray()) : this.context.find(query, offset, offset + limit - 1, params.toArray()));
        return result;
    }

    public BatchModel findModelByTopiaId(String batchId) throws TopiaException {
        String query = this.getFindBatchModelQueryPrefix() + " from " + Batch.class.getName() + " B" + " where B." + "topiaId" + " = :batchId";
        BatchModel result = null;
        Object[] beanAndQt = (Object[])this.context.findUnique(query, new Object[]{"batchId", batchId});
        if (beanAndQt != null) {
            Double pres = (Double)beanAndQt[1];
            Double sale = (Double)beanAndQt[2];
            Date dmes = (Date)beanAndQt[3];
            result = new BatchModel((Batch)beanAndQt[0], pres == null ? 0.0 : pres, sale == null ? 0.0 : sale, dmes);
        }
        return result;
    }

    public List<Batch> getBatchWithOutputAndPendingAnalysis() throws TopiaException {
        String query = "from " + Batch.class.getName() + " B" + " where B in (" + "  SELECT E.presentation.batch FROM " + Expedition.class.getName() + " E" + " ) AND B in (" + "  SELECT A.batch FROM " + BatchAnalyze.class.getName() + " A" + "   WHERE A." + "receiptDate" + " = null)" + " ORDER BY B." + "number";
        List result = this.context.findAll(query, new Object[0]);
        return result;
    }

    public List<Batch> getBatchWithInputAndPendingAnalysis() throws TopiaException {
        String query = "from " + Batch.class.getName() + " B" + " where B in (" + "  SELECT P.presentation.batch FROM " + Production.class.getName() + " P" + " ) AND B in (" + "  SELECT A.batch FROM " + BatchAnalyze.class.getName() + " A" + "   WHERE A." + "receiptDate" + " = null)" + " ORDER BY B." + "number";
        List result = this.context.findAll(query, new Object[0]);
        return result;
    }

    public List<Batch> getBatchWithMoreSellThanStock() throws TopiaException {
        String query = "SELECT B from " + Batch.class.getName() + " B" + " where " + "expiredDate" + " = null" + " AND (select COALESCE(sum(E.quantity),0) from " + Expedition.class.getName() + " E where E.presentation.batch = B)" + " - (select COALESCE(sum(E.quantity),0) from " + Expedition.class.getName() + " E where E.correction.batch = B) > B." + "quantity" + " ORDER BY B." + "number";
        List result = this.context.findAll(query, new Object[0]);
        return result;
    }

    public List<Batch> getDedicatedClientExpiredBatch() throws TopiaException {
        String query = "from " + Batch.class.getName() + " B" + " where " + "expiredDate" + " = null" + " AND " + "dedicatedClient" + " != null" + " AND (SELECT sum(P." + "quantity" + ") FROM " + Presentation.class.getName() + " P" + "  WHERE P.batch = B) <= 0" + " ORDER BY B." + "number";
        List result = this.context.findAll(query, new Object[0]);
        return result;
    }

    public List<Batch> getBatchWithNoStock() throws TopiaException {
        String query = "from " + Batch.class.getName() + " B" + " where " + "expiredDate" + " = null" + " AND (SELECT sum(P." + "quantity" + ") FROM " + Presentation.class.getName() + " P" + "  WHERE P.batch = B) = 0" + " ORDER BY B." + "number";
        List result = this.context.findAll(query, new Object[0]);
        return result;
    }

    public List<Batch> getBatchWithBulletinToAsk() throws TopiaException {
        String query = "from " + Batch.class.getName() + " B" + " where " + "expiredDate" + " = null" + " AND B IN (SELECT A.batch FROM " + BatchAnalyze.class.getName() + " A" + "  WHERE A.sentDate != null" + "  AND A.receiptDate = null" + "  AND A.supplier.laboratory = false)" + " ORDER BY B." + "number";
        List result = this.context.findAll(query, new Object[0]);
        return result;
    }

    public Date getMaxEntryDate() throws TopiaException {
        String query = "select max(entryDate) from " + Batch.class.getName() + " B";
        Date result = (Date)this.context.findUnique(query, new Object[0]);
        return result;
    }
}

