/*
 * #%L
 * SGQ :: Business
 * $Id: PlaceImportModel.java 229 2012-12-17 16:34:13Z echatellier $
 * $HeadURL: https://svn.codelutin.com/sgq-ch/tags/sgq-ch-1.1.5/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/PlaceImportModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import java.text.ParseException;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.Zone;

/**
 * Modèle d'import du fichier CSV des emplacements.
 * 
 * Zone;Empl.;Code Présentation;Code Produit;Nom de la plante;Nom du produit
 * 
 * @author echatellier
 */
public class PlaceImportModel extends AbstractImportModel<PlaceBean> {

    public PlaceImportModel(final Map<String, Product> products) {
        super(';');
        newMandatoryColumn("Zone", PlaceBean.PROPERTY_ZONE, new ValueParser<Zone>() {
            @Override
            public Zone parse(String value) throws ParseException {
                return Zone.valueOf(value);
            }
        });
        newMandatoryColumn("Emplacement", PlaceBean.PROPERTY_CODE);
        newMandatoryColumn("Localisation", PlaceBean.PROPERTY_NAME);
        newMandatoryColumn("Code Pr\u00E9sentation", PlaceBean.PROPERTY_PRESENTATION_CODE, new ValueParser<PresentationCode>() {
            @Override
            public PresentationCode parse(String value) throws ParseException {
                PresentationCode presentationCode = null;
                // la valeur vide est autorisée
                if (StringUtils.isBlank(value)) {
                    presentationCode = PresentationCode._; // vide = .
                } else {
                    presentationCode = PresentationCode.getPresentationCodeFor(value.charAt(0));
                }
                return presentationCode;
            }
        });
        newMandatoryColumn("Code Produit", PlaceBean.PROPERTY_PRODUCT, new ValueParser<Product>() {
            @Override
            public Product parse(String value) throws ParseException {
                Product product = products.get(value);
                if (product == null) {
                    throw new SgqBusinessException("Can't find product " + value);
                }
                return product;
            }
        });
        newIgnoredColumn("Nom de la Plante");
        newIgnoredColumn("Nom du produit");
    }

    @Override
    public PlaceBean newEmptyInstance() {
        return new PlaceBean();
    }
}
