/*
 * #%L
 * SGQ :: Business
 * $Id: ProductionDAOImpl.java 271 2013-02-11 13:37:56Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.2/sgq-business/src/main/java/com/herbocailleau/sgq/entities/ProductionDAOImpl.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

import java.util.Date;

import org.nuiton.topia.TopiaException;

public class ProductionDAOImpl<E extends Production> extends ProductionDAOAbstract<E> {
    
    /**
     * Trouve parmis les production la date de la derniere production
     * effectuer par la zone source specifiée.
     * 
     * @param zone zone source
     * @return date or {@code null}
     * @throws TopiaException 
     */
    public Date findMaxDateForZone(Zone zone) throws TopiaException {
        String query = "select max(date) from " + Production.class.getName() +
                " where " + Production.PROPERTY_SOURCE + " = :zone";
        
        Date result = (Date)context.findUnique(query, "zone", zone);
        return result;
    }

} //ProductionDAOImpl<E extends Production>
