/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class PresentationAbstract
extends TopiaEntityAbstract
implements Presentation {
    protected double quantity;
    protected Date dmesd;
    protected boolean original;
    protected Batch batch;
    protected PresentationCode presentationCode;
    protected Collection<Place> inventoryPlaces;
    private static final long serialVersionUID = 7005457395135558704L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "quantity", Double.TYPE, (Object)this.quantity);
        visitor.visit((TopiaEntity)this, "dmesd", Date.class, (Object)this.dmesd);
        visitor.visit((TopiaEntity)this, "original", Boolean.TYPE, (Object)this.original);
        visitor.visit((TopiaEntity)this, "batch", Batch.class, (Object)this.batch);
        visitor.visit((TopiaEntity)this, "presentationCode", PresentationCode.class, (Object)this.presentationCode);
        visitor.visit((TopiaEntity)this, "inventoryPlaces", Collection.class, Place.class, this.inventoryPlaces);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setQuantity(double quantity) {
        double oldValue = this.quantity;
        this.fireOnPreWrite("quantity", oldValue, quantity);
        this.quantity = quantity;
        this.fireOnPostWrite("quantity", oldValue, quantity);
    }

    @Override
    public double getQuantity() {
        this.fireOnPreRead("quantity", this.quantity);
        double result = this.quantity;
        this.fireOnPostRead("quantity", this.quantity);
        return result;
    }

    @Override
    public void setDmesd(Date dmesd) {
        Date oldValue = this.dmesd;
        this.fireOnPreWrite("dmesd", oldValue, dmesd);
        this.dmesd = dmesd;
        this.fireOnPostWrite("dmesd", oldValue, dmesd);
    }

    @Override
    public Date getDmesd() {
        this.fireOnPreRead("dmesd", this.dmesd);
        Date result = this.dmesd;
        this.fireOnPostRead("dmesd", this.dmesd);
        return result;
    }

    @Override
    public void setOriginal(boolean original) {
        boolean oldValue = this.original;
        this.fireOnPreWrite("original", oldValue, original);
        this.original = original;
        this.fireOnPostWrite("original", oldValue, original);
    }

    @Override
    public boolean isOriginal() {
        this.fireOnPreRead("original", this.original);
        boolean result = this.original;
        this.fireOnPostRead("original", this.original);
        return result;
    }

    @Override
    public boolean getOriginal() {
        this.fireOnPreRead("original", this.original);
        boolean result = this.original;
        this.fireOnPostRead("original", this.original);
        return result;
    }

    @Override
    public void setBatch(Batch batch) {
        Batch oldValue = this.batch;
        this.fireOnPreWrite("batch", oldValue, batch);
        this.batch = batch;
        this.fireOnPostWrite("batch", oldValue, batch);
    }

    @Override
    public Batch getBatch() {
        this.fireOnPreRead("batch", this.batch);
        Batch result = this.batch;
        this.fireOnPostRead("batch", this.batch);
        return result;
    }

    @Override
    public void setPresentationCode(PresentationCode presentationCode) {
        PresentationCode oldValue = this.presentationCode;
        this.fireOnPreWrite("presentationCode", (Object)oldValue, (Object)presentationCode);
        this.presentationCode = presentationCode;
        this.fireOnPostWrite("presentationCode", (Object)oldValue, (Object)presentationCode);
    }

    @Override
    public PresentationCode getPresentationCode() {
        this.fireOnPreRead("presentationCode", (Object)this.presentationCode);
        PresentationCode result = this.presentationCode;
        this.fireOnPostRead("presentationCode", (Object)this.presentationCode);
        return result;
    }

    @Override
    public void addInventoryPlaces(Place inventoryPlaces) {
        this.fireOnPreWrite("inventoryPlaces", null, inventoryPlaces);
        if (this.inventoryPlaces == null) {
            this.inventoryPlaces = new ArrayList<Place>();
        }
        this.inventoryPlaces.add(inventoryPlaces);
        this.fireOnPostWrite("inventoryPlaces", this.inventoryPlaces.size(), null, inventoryPlaces);
    }

    @Override
    public void addAllInventoryPlaces(Collection<Place> inventoryPlaces) {
        if (inventoryPlaces == null) {
            return;
        }
        for (Place item : inventoryPlaces) {
            this.addInventoryPlaces(item);
        }
    }

    @Override
    public void setInventoryPlaces(Collection<Place> inventoryPlaces) {
        ArrayList<Place> oldValue = this.inventoryPlaces != null ? new ArrayList<Place>(this.inventoryPlaces) : null;
        this.fireOnPreWrite("inventoryPlaces", oldValue, inventoryPlaces);
        this.inventoryPlaces = inventoryPlaces;
        this.fireOnPostWrite("inventoryPlaces", oldValue, inventoryPlaces);
    }

    @Override
    public void removeInventoryPlaces(Place inventoryPlaces) {
        this.fireOnPreWrite("inventoryPlaces", inventoryPlaces, null);
        if (this.inventoryPlaces == null || !this.inventoryPlaces.remove(inventoryPlaces)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("inventoryPlaces", this.inventoryPlaces.size() + 1, inventoryPlaces, null);
    }

    @Override
    public void clearInventoryPlaces() {
        if (this.inventoryPlaces == null) {
            return;
        }
        ArrayList<Place> oldValue = new ArrayList<Place>(this.inventoryPlaces);
        this.fireOnPreWrite("inventoryPlaces", oldValue, this.inventoryPlaces);
        this.inventoryPlaces.clear();
        this.fireOnPostWrite("inventoryPlaces", oldValue, this.inventoryPlaces);
    }

    @Override
    public Collection<Place> getInventoryPlaces() {
        return this.inventoryPlaces;
    }

    @Override
    public Place getInventoryPlacesByTopiaId(String topiaId) {
        return (Place)TopiaEntityHelper.getEntityByTopiaId(this.inventoryPlaces, (String)topiaId);
    }

    @Override
    public int sizeInventoryPlaces() {
        if (this.inventoryPlaces == null) {
            return 0;
        }
        return this.inventoryPlaces.size();
    }

    @Override
    public boolean isInventoryPlacesEmpty() {
        int size = this.sizeInventoryPlaces();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }
}

