/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services.csv;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.services.csv.BatchBean;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.Country;
import com.herbocailleau.sgq.entities.Supplier;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

public class BatchImportModel
extends AbstractImportModel<BatchBean> {
    public BatchImportModel(final Map<String, Supplier> suppliers, final Map<String, Client> clients) {
        super(';');
        this.newMandatoryColumn("DATE_R", "entryDate", (ValueParser)new ValueParser<Date>(){

            public Date parse(String value) throws ParseException {
                return SgqUtils.parseSgqDate(value);
            }
        });
        this.newMandatoryColumn("CODF_R", "supplier", (ValueParser)new ValueParser<Supplier>(){

            public Supplier parse(String value) throws ParseException {
                Supplier supplier = (Supplier)suppliers.get(value);
                if (supplier == null) {
                    throw new SgqBusinessException(I18n._((String)"Impossible de trouver le fournisseur %s", (Object[])new Object[]{value}));
                }
                return supplier;
            }
        });
        this.newIgnoredColumn("FOUR_R");
        this.newMandatoryColumn("COMM_R", "orderNumber", (ValueParser)new ValueParser<Integer>(){

            public Integer parse(String value) throws ParseException {
                return Integer.valueOf(value);
            }
        });
        this.newMandatoryColumn("COLIS_R", "packageCount", (ValueParser)new ValueParser<Integer>(){

            public Integer parse(String value) throws ParseException {
                return Integer.valueOf(value);
            }
        });
        this.newMandatoryColumn("POIDS_R", "quantity", (ValueParser)new ValueParser<Double>(){

            public Double parse(String value) throws ParseException {
                return Double.valueOf(value.replace(',', '.').replaceAll("[^\\d.]", ""));
            }
        });
        this.newMandatoryColumn("PRO_R", "productCode", (ValueParser)new ValueParser<String>(){

            public String parse(String value) throws ParseException {
                if (StringUtils.length((CharSequence)value) != 6) {
                    throw new SgqBusinessException(I18n._((String)"Code produit invalide %s ", (Object[])new Object[]{value}));
                }
                return value;
            }
        });
        this.newIgnoredColumn("PAYS_R");
        this.newMandatoryColumn("CODP_R", "origin", (ValueParser)new ValueParser<Country>(){

            public Country parse(String value) throws ParseException {
                return Country.valueOf(value);
            }
        });
        this.newMandatoryColumn("LOT_R", "number", (ValueParser)new ValueParser<Integer>(){

            public Integer parse(String value) throws ParseException {
                return Integer.valueOf(value);
            }
        });
        this.newMandatoryColumn("DLUO_R", "dluo", (ValueParser)new ValueParser<Date>(){

            public Date parse(String value) throws ParseException {
                return SgqUtils.parseSgqDate(value);
            }
        });
        this.newIgnoredColumn("CLI_R");
        this.newMandatoryColumn("CODC_R", "dedicatedClient", (ValueParser)new ValueParser<Client>(){

            public Client parse(String value) throws ParseException {
                Client client = null;
                if (StringUtils.isNotBlank((CharSequence)value) && (client = (Client)clients.get(value)) == null) {
                    throw new SgqBusinessException(I18n._((String)"Impossible de trouver le client %s", (Object[])new Object[]{value}));
                }
                return client;
            }
        });
        this.newMandatoryColumn("ECH_R", "sampleCode");
        this.newMandatoryColumn("REM_R", "comment");
        this.newMandatoryColumn("IG_R", "invalid", (ValueParser)new ValueParser<Boolean>(){

            public Boolean parse(String value) throws ParseException {
                Boolean result = Boolean.FALSE;
                if ("O".equalsIgnoreCase(value)) {
                    result = Boolean.TRUE;
                }
                return result;
            }
        });
        this.newMandatoryColumn("Date \u00e9puiss\u00e9", "expiredDate", (ValueParser)new ValueParser<Date>(){

            public Date parse(String value) throws ParseException {
                Date result = null;
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    result = SgqUtils.parseSgqDate(value);
                }
                return result;
            }
        });
        this.newMandatoryColumn("DMES", "dmes", (ValueParser)new ValueParser<Date>(){

            public Date parse(String value) throws ParseException {
                Date result = null;
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    result = SgqUtils.parseSgqDate(value);
                }
                return result;
            }
        });
    }

    public BatchBean newEmptyInstance() {
        return new BatchBean();
    }
}

