/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business;

import com.herbocailleau.sgq.SGQDAOHelper;
import com.herbocailleau.sgq.business.ServiceDAOHelper;
import com.herbocailleau.sgq.business.SgqBusinessConfig;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.entities.BatchImpl;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaUtil;

public class ServiceFactory {
    private static final Log log = LogFactory.getLog(ServiceFactory.class);
    protected static TopiaContext rootContext;
    protected static SgqBusinessConfig config;

    public static SgqBusinessConfig getConfig() {
        if (config == null) {
            config = new SgqBusinessConfig();
            config.parse();
        }
        return config;
    }

    public static TopiaContext getRootContext() {
        if (rootContext == null) {
            SgqBusinessConfig config = ServiceFactory.getConfig();
            Properties props = config.getFlatOptions();
            props.setProperty("topia.persistence.classes", SGQDAOHelper.getImplementationClassesAsString());
            try {
                rootContext = TopiaContextFactory.getContext((Properties)props);
                ServiceFactory.initSchema(rootContext);
            }
            catch (TopiaException ex) {
                throw new RuntimeException("Can't init root context", ex);
            }
        }
        return rootContext;
    }

    protected static void initSchema(TopiaContext rootContext) throws TopiaException {
        TopiaContext transaction = rootContext.beginTransaction();
        boolean testBatch = TopiaUtil.isSchemaExist((TopiaContext)transaction, (String)BatchImpl.class.getName());
        transaction.closeContext();
        if (!testBatch) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Create database schema");
            }
            rootContext.createSchema();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Table batch found, skip schema creation");
        }
    }

    public static <E extends SgqService> E newService(Class<E> serviceClass, TopiaContext transaction) {
        SgqService service = null;
        try {
            service = (SgqService)serviceClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Can't instanciate service", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Can't instanciate service", ex);
        }
        ServiceDAOHelper daoHelper = new ServiceDAOHelper(transaction);
        service.setServiceDAOHelper(daoHelper);
        service.setConfig(ServiceFactory.getConfig());
        return (E)service;
    }
}

