/*
 * #%L
 * SGQ :: Business
 * $Id: InventoryExportModel.java 113 2012-10-02 14:38:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/InventoryExportModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.ExportableColumn;
import org.nuiton.util.csv.ModelBuilder;
import org.nuiton.util.csv.ValueFormatter;

import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Presentation;

/**
 * zone, emplacement, code produit, nom produit, lot, quantité, valeurs relevées
 * 
 * @author echatellier
 */
public class InventoryExportModel implements ExportModel<InventoryBean> {

    @Override
    public char getSeparator() {
        return ';';
    }

    @Override
    public Iterable<ExportableColumn<InventoryBean, Object>> getColumnsForExport() {
        ModelBuilder<Batch> modelBuilder = new ModelBuilder<Batch>();
        modelBuilder.newColumnForExport("Zone", InventoryBean.PROPERTY_PLACE, new ValueFormatter<Place>() {
            @Override
            public String format(Place value) {
                String result = null;
                if (value != null) {
                    result = value.getZone().toString();
                } else {
                    result = "";
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Emplacement", InventoryBean.PROPERTY_PLACE, new ValueFormatter<Place>() {
            @Override
            public String format(Place value) {
                String result = null;
                if (value != null) {
                    result = value.getCode();
                } else {
                    result = "";
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Code produit", InventoryBean.PROPERTY_PRESENTATION, new ValueFormatter<Presentation>() {
            @Override
            public String format(Presentation value) {
                String result = value.getPresentationCode().getCode() + 
                        value.getBatch().getProduct().getCode();
                return result;
            }
        });
        modelBuilder.newColumnForExport("Nom produit", InventoryBean.PROPERTY_BATCH, new ValueFormatter<Batch>() {
            @Override
            public String format(Batch value) {
                return value.getProduct().getName();
            }
        });
        modelBuilder.newColumnForExport("Lot", InventoryBean.PROPERTY_BATCH, new ValueFormatter<Batch>() {
            @Override
            public String format(Batch value) {
                return String.valueOf(value.getNumber());
            }
        });
        modelBuilder.newColumnForExport("Quantité", InventoryBean.PROPERTY_BATCH_MODEL, new ValueFormatter<BatchModel>() {
            @Override
            public String format(BatchModel value) {
                return String.valueOf(value.getTotalPresentation());
            }
        });
        modelBuilder.newColumnForExport("Valeurs relevées", InventoryBean.PROPERTY_BATCH_MODEL, new ValueFormatter<BatchModel>() {
            @Override
            public String format(BatchModel value) {
                return ""; // a remplir à l'import
            }
        });
        return (Iterable) modelBuilder.getColumnsForExport();
    }
}
